require(["jquery", "actonic-gdpr/global/rest", "actonic-gdpr/core/flags", "actonic-gdpr/domReady", "actonic-gdpr/core/wait-for-element", "actonic-gdpr/core/utils"], function ($, Rest, flags, domReady, WaitForElement, Utils) {
    $(document).ready(function () {
        new PinnedAnnouncements().init();
    });

    function PinnedAnnouncements() {
        var isAnnouncingBottom = false;
        this.init = function () {
            WaitForElement.waitFor(".footer-body>ul:last", getPinnedAnnouncements);

            $(document).click(function (e) {
                var container = $(".aui-blanket");
                if (isAnnouncingBottom && container.is(e.target) && container.has(e.target).length === 0) {
                    $("#custom-main").remove();
                }
            });
        };

        function getPinnedAnnouncements() {
            Rest.getPinnedAnnouncements(
                function (announcements) { // success
                    $("<ul class='atlassian-footer custom-ul-pinned'></ul>").insertAfter(".footer-body>ul:last");

                    $.each(announcements, function (index, item) {
                        $(".custom-ul-pinned").append("<li class='custom-pinned' style='cursor: pointer;' data-id=" + item.id + ">" + item.title + "</li>");
                    });

                    $("li.custom-pinned").click(function () {
                        var dataId = $(this).attr("data-id");
                        $.each(announcements, function (index, item) {
                            if (dataId == item.id) {
                                Rest.getAnnouncingBody(item.id, function (data) {
                                    item.body = data;
                                    if (item.style === "center") {
                                        renderAnnouncingDialog(item);
                                    } else if (item.style === "bottom") {
                                        renderAnnouncingBottom(item);
                                    }
                                });

                                return false;
                            }
                        })
                    });
                },
                function (error) { // error
                    log.error("Rest.getAnnouncingForUser error = " + JSON.stringify(error));
                });
        }

        function renderAnnouncingBottom(announcing) {
            var winNumericSize = Utils.getWinNumericaSize(announcing.windowSize);
            var bottom = ACTONIC.GDPR.GLOBAL.getAnnouncingBottom({
                id: announcing.id,
                title: announcing.title,
                baseUrl: AJS.contextPath(),
                announcingbody: announcing.body,
                type: announcing.type,
                method: "render",
                pageId: announcing.pageId,
                content: announcing.content,
                windowSize: winNumericSize,
                accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                action: announcing.extraFields.action,
                questionnaire: announcing.questionnaire,
                response: announcing.extraFields.response
            });

            $("body").append(bottom);
            isAnnouncingBottom = true;
            $("#announcing-bottom-" + announcing.id).show();
            $("#announcing-bottom-" + announcing.id + "-accept-btn").click(function () {
                actionAnnouncingBottom("accepted", announcing.id);
            });
            $("#announcing-bottom-" + announcing.id + "-decline-btn").click(function () {
                actionAnnouncingBottom("declined", announcing.id);
            });
            $("#announcing-bottom-" + announcing.id + "-acknowledge-btn").click(function () {
                $("#custom-main").remove();
            });
        }

        function renderAnnouncingDialog(announcing) {
            var windowSize = announcing.windowSize ? announcing.windowSize : "medium";
            var dialog = ACTONIC.GDPR.GLOBAL.getAnnouncingDialog({
                id: announcing.id,
                title: announcing.title,
                baseUrl: AJS.contextPath(),
                announcingbody: announcing.body,
                type: announcing.type,
                method: "optional",
                pageId: announcing.pageId,
                content: announcing.content,
                windowSize: windowSize,
                accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                action: announcing.extraFields.action,
                questionnaire: announcing.questionnaire,
                response: announcing.extraFields.response
            });

            $("body").append(dialog);
            AJS.dialog2("#announcing-dialog-" + announcing.id).show();
            $("#announcing-dialog-" + announcing.id + "-accept-btn").click(function () {
                actionAnnouncingDialog("accepted", announcing.id);
            });
            $("#announcing-dialog-" + announcing.id + "-decline-btn").click(function () {
                //log.debug("cancel-btn click");
                actionAnnouncingDialog("declined", announcing.id);
            });
            $("#announcing-dialog-" + announcing.id + "-acknowledge-btn").click(function () {
                AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
            });
        }

        function actionAnnouncingBottom(action, id) {
            var request = Utils.getQuestionnaire();
            if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                return;
            }
            Rest.updatePinnedAnnouncing(action, id, request,
                function () { // success
                    $("#custom-main").remove();
                    if (action === "accepted") {
                        flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-accept-announcing-flag-done-body"));
                    } else if (action === "declined") {
                        flags.simpleWarning(AJS.I18n.getText("js-global-display-announcing-decline-announcing-flag-done-body"));
                    }
                    isAnnouncingBottom = false;
                },
                function (error) { // error
                    $("#custom-main").remove();
                    flags.showFlag("Error", JSON.stringify(error), "warning");
                    isAnnouncingBottom = false;
                });
        }

        function actionAnnouncingDialog(action, id) {
            var request = Utils.getQuestionnaire();
            if (request.questionnaire.length > Utils.MAX_STRING_LENGTH) {
                flags.simpleWarning(AJS.I18n.getText("js-global.display-announcing.rest.maximum-announcing-flag-warning"));
                return;
            }
            Rest.updatePinnedAnnouncing(action, id, request,
                function () { // success
                    AJS.dialog2("#announcing-dialog-" + id).hide();
                    if (action === "accepted") {
                        flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-accept-announcing-flag-done-body"));
                    } else if (action === "declined") {
                        flags.simpleWarning(AJS.I18n.getText("js-global-display-announcing-decline-announcing-flag-done-body"));
                    }
                },
                function (error) { // error
                    AJS.dialog2("#announcing-dialog-" + id).hide();
                    flags.showFlag("Error", JSON.stringify(error), "warning");
                });
        }
    }

    return new PinnedAnnouncements();
});
