/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.general.manager.GDPRAbstractEntityDao;
import de.actonic.gdpr.newDC.ao.TaskDCEntity;
import de.actonic.gdpr.newDC.ao.TemplateDCEntity;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskDCDao
extends GDPRAbstractEntityDao {
    @Autowired
    public TaskDCDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public void setLastUpdateTime(Integer taskId) {
        TaskDCEntity entity = this.getById(taskId);
        entity.setLastUpdateTime(System.currentTimeMillis());
        entity.save();
    }

    public void findAllStream() {
        this.ao.stream(TaskDCEntity.class, (EntityStreamCallback)new EntityStreamCallback<TaskDCEntity, Integer>(){

            public void onRowRead(TaskDCEntity taskDCEntity) {
                System.out.println(taskDCEntity.getTaskType());
            }
        });
    }

    public TaskDCEntity cancelTask(Integer taskId, String message) {
        TaskDCEntity entity = this.getById(taskId);
        entity.setStatus(TaskDCStatus.ABORTED.getCode());
        entity.setEndDate(new Date());
        entity.setTaskMessage(message);
        entity.save();
        return entity;
    }

    public TaskDCEntity cancelTaskByTemplated(Integer templateId, String message) {
        TaskDCEntity entity = this.getByTemplateId(templateId);
        entity.setStatus(TaskDCStatus.ABORTED.getCode());
        entity.setEndDate(new Date());
        entity.setTaskMessage(message);
        entity.save();
        return entity;
    }

    public TaskDCEntity getFirstFilteredTask(Integer status, Integer type) {
        return this.getFirstByQuery(TaskDCEntity.class, this.createQueryForFilteredTasks(status, type));
    }

    public List<TaskDCEntity> getFilteredTasks(Integer status, Integer type) {
        return Lists.newArrayList(this.ao.find(TaskDCEntity.class, this.createQueryForFilteredTasks(status, type)));
    }

    private Query createQueryForFilteredTasks(Integer status, Integer type) {
        Query query = Query.select().order("ID ASC");
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (status != null) {
            TaskDCDao.appendDelimiter(sb, "STATUS = ?");
            values.add(status);
        }
        if (type != null) {
            TaskDCDao.appendDelimiter(sb, "TASK_TYPE = ?");
            values.add(type);
        }
        if (sb.length() > 0 && !values.isEmpty()) {
            query.setWhereClause(sb.toString());
            query.setWhereParams(values.toArray());
        }
        return query;
    }

    public TaskDCEntity createTask(Integer templateId, String username, Integer type) {
        TemplateDCEntity template = (TemplateDCEntity)this.ao.get(TemplateDCEntity.class, (Object)templateId);
        TaskDCEntity entity = (TaskDCEntity)this.ao.create(TaskDCEntity.class, new DBParam[0]);
        entity.setTemplate(template);
        entity.setTemplateVersion(template.getVersion());
        entity.setCreator(username);
        entity.setCreateDate(new Date());
        entity.setStatus(TaskDCStatus.NOT_STARTED.getCode());
        entity.setTaskType(type);
        entity.setTaskMessage("Task queued");
        entity.save();
        return entity;
    }

    public boolean hasTaskForTemplate(Integer templateId) {
        int count = this.ao.count(TaskDCEntity.class, Query.select().where("TEMPLATE_ID = ? AND (STATUS = 0 OR STATUS = 1)", new Object[]{templateId}));
        return count > 0;
    }

    public List<TaskDCEntity> getHistoricalTasksForTemplate(Integer templateId) {
        return Lists.newArrayList(this.ao.find(TaskDCEntity.class, Query.select().where("TEMPLATE_ID = ? AND (STATUS = ? OR STATUS = ? OR STATUS = ?)", new Object[]{templateId, TaskDCStatus.ABORTED.getCode(), TaskDCStatus.FINISHED.getCode(), TaskDCStatus.FAILED.getCode()}).order("ID ASC")));
    }

    public List<TaskDCEntity> getTaskListByStatus(Integer status) {
        return Lists.newArrayList(this.ao.find(TaskDCEntity.class, Query.select().where("STATUS = ?", new Object[]{status}).order("ID ASC")));
    }

    public TaskDCEntity getById(int id) {
        return this.getFirstByField(TaskDCEntity.class, "ID", id);
    }

    public TaskDCEntity getByTemplateId(int templateId) {
        return this.getLastByField(TaskDCEntity.class, "TEMPLATE_ID", templateId);
    }

    public TaskDCEntity start(Integer taskId) {
        TaskDCEntity entity = this.getById(taskId);
        entity.setStatus(TaskDCStatus.IN_PROGRESS.getCode());
        entity.setStartDate(new Date());
        entity.save();
        return entity;
    }

    public TaskDCEntity failed(Integer taskId, String errorMessage) {
        TaskDCEntity entity = this.getById(taskId);
        entity.setStatus(TaskDCStatus.FAILED.getCode());
        entity.setEndDate(new Date());
        entity.setTaskMessage(errorMessage);
        entity.save();
        return entity;
    }

    public TaskDCEntity finish(Integer taskId, int affectedNum, int skipNum, String finishMessage) {
        TaskDCEntity entity = this.getById(taskId);
        entity.setStatus(TaskDCStatus.FINISHED.getCode());
        entity.setEndDate(new Date());
        entity.setTaskCurrentNum(entity.getTaskTotalNum());
        entity.setTaskAffectedNum(affectedNum);
        entity.setTaskMessage(finishMessage);
        entity.setSkippedIssueCount(skipNum);
        entity.save();
        return entity;
    }

    public void setFoundObjectsCount(Integer taskId, Integer historyEntitiesCountByJobId) {
        TaskDCEntity entity = (TaskDCEntity)this.ao.get(TaskDCEntity.class, (Object)taskId);
        entity.setFoundObjectsCount(historyEntitiesCountByJobId);
        entity.save();
    }

    public Integer getTaskCountForTemplate(int templateId) {
        return this.ao.count(TaskDCEntity.class, Query.select().where("TEMPLATE_ID = ? ", new Object[]{templateId}));
    }

    public List<TaskDCEntity> getAllTasksForRemovingByTemplateId(int templateId) {
        return Lists.newArrayList(this.ao.find(TaskDCEntity.class, Query.select().where("TEMPLATE_ID = ?", new Object[]{templateId}).order("ID ASC")));
    }

    public void delete(Integer taskId) {
        TaskDCEntity entity = this.getById(taskId);
        this.ao.delete(new RawEntity[]{entity});
    }
}

