/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DCWatcherChangerNew
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;

    public DCWatcherChangerNew(NotificationManager notificationManager, PageManager pageManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        super(pageManager);
        this.notificationManager = notificationManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    public String getType() {
        return "user";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(contentObjectId.longValue());
            ArrayList<DCIFieldChangerValue> resultList = Lists.newArrayList(new DCIFieldChangerValue[0]);
            List notifications = this.notificationManager.getNotificationsByContent(ceo);
            for (Notification notification : notifications) {
                if (notification.getReceiver() == null) continue;
                resultList.add((DCIFieldChangerValue)new DCFieldChangerValue(notification.getReceiver().getKey().toString()));
            }
            return resultList;
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(contentObjectId.longValue());
            List notifications = this.notificationManager.getNotificationsByContent(ceo);
            for (Notification notification : notifications) {
                String recieverName = notification.getReceiver().getKey().toString();
                if (!StringUtils.isNotBlank((CharSequence)recieverName)) continue;
                for (Map.Entry entry : oldNewValueMap.entrySet()) {
                    ConfluenceUser source;
                    if (!recieverName.equals(((DCIFieldChangerValue)entry.getKey()).getValue()) || (source = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()))) == null) continue;
                    notification.setReceiver(source);
                }
            }
            return true;
        });
    }
}

