/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DCTitleChanger
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    public DCTitleChanger(@ComponentImport PageManager pageManager, TransactionTemplate transactionTemplate, DraftsTransitionHelper draftsTransitionHelper) {
        super(pageManager);
        this.transactionTemplate = transactionTemplate;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    public String getType() {
        return "text";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            return ceo != null ? Lists.newArrayList(new DCFieldChangerValue(ceo.getTitle())) : Lists.newArrayList(new DCIFieldChangerValue[0]);
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject tCeo = this.getPageById(contentObjectId);
            String title = tCeo.getTitle();
            for (Map.Entry entry : oldNewValueMap.entrySet()) {
                title = (String)entry.getValue();
            }
            title = this.fixPageTitle(title, tCeo);
            tCeo.setTitle(title);
            this.saveContentEntity(tCeo, this.SAVE_CONTEXT);
            ContentEntityObject draft = this.draftsTransitionHelper.getDraftForPage((AbstractPage)tCeo);
            if (draft != null) {
                draft.setTitle(title);
                this.saveContentEntity(draft, this.SAVE_CONTEXT);
            }
            return true;
        });
    }

    private String fixPageTitle(String currentTitle, ContentEntityObject currentCeo) {
        String fixedTitle;
        block3: {
            Integer counter;
            block2: {
                fixedTitle = currentTitle;
                counter = 1;
                if (!(currentCeo instanceof Page)) break block2;
                while (this.getPage(((Page)currentCeo).getSpaceKey(), fixedTitle) != null) {
                    fixedTitle = currentTitle + " (" + counter + ")";
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                }
                break block3;
            }
            if (!(currentCeo instanceof BlogPost)) break block3;
            while (this.getBlogPost(((BlogPost)currentCeo).getSpaceKey(), fixedTitle, ((BlogPost)currentCeo).getPostingCalendarDate()) != null) {
                fixedTitle = currentTitle + " (" + counter + ")";
                Integer n = counter;
                Integer n3 = counter = Integer.valueOf(counter + 1);
            }
        }
        return fixedTitle;
    }
}

