/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DCCreatorUpdaterChanger
extends DCConfluenceFieldChanger {
    private static final Logger log = LoggerFactory.getLogger(DCCreatorUpdaterChanger.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final ContentEntityObjectDao contentEntityObjectDao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    protected EntityManagerProvider entityManagerProvider;

    public DCCreatorUpdaterChanger(@ComponentImport PageManager pageManager, UserAccessor userAccessor, ContentEntityObjectDao contentEntityObjectDao, TransactionTemplate transactionTemplate) {
        super(pageManager);
        this.userAccessor = userAccessor;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.transactionTemplate = transactionTemplate;
    }

    public String getType() {
        return "user";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            HashSet<DCFieldChangerValue> resultList = new HashSet<DCFieldChangerValue>();
            if (ceo.getCreator() != null) {
                resultList.add(new DCFieldChangerValue(ceo.getCreator().getKey().toString()));
            }
            if (ceo.getLastModifier() != null) {
                resultList.add(new DCFieldChangerValue(ceo.getLastModifier().getKey().toString()));
            }
            EntityManager entityManager = this.getSessionOrThrowException();
            try {
                String strQuery = "select re.sourceContent from User2ContentRelationEntity re where (re.relationName = :collaborator or re.relationName = :touched) and re.targetContent = :targetContent";
                Query query = entityManager.createQuery(strQuery);
                query.setParameter("targetContent", (Object)ceo);
                query.setParameter("collaborator", (Object)"collaborator");
                query.setParameter("touched", (Object)"touched");
                List collaboratorEntities = query.getResultList();
                collaboratorEntities.stream().map(entity -> (ConfluenceUser)entity).forEach(user -> resultList.add(new DCFieldChangerValue(user.getKey().getStringValue())));
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
            return Lists.newArrayList(resultList);
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            ArrayList<ConfluenceUser> affectedUsers = Lists.newArrayList(new ConfluenceUser[0]);
            for (Map.Entry entry : oldNewValueMap.entrySet()) {
                ConfluenceUser sourceUser = this.userAccessor.getUserByKey(new UserKey(((DCIFieldChangerValue)entry.getKey()).getValue()));
                ConfluenceUser targetUser = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                if (ceo.getCreator() != null && StringUtils.equalsIgnoreCase((CharSequence)ceo.getCreator().getKey().toString(), (CharSequence)((DCIFieldChangerValue)entry.getKey()).getValue())) {
                    affectedUsers.add(ceo.getCreator());
                    ceo.setCreator(targetUser);
                }
                if (ceo.getLastModifier() != null && StringUtils.equalsIgnoreCase((CharSequence)ceo.getLastModifier().getKey().toString(), (CharSequence)((DCIFieldChangerValue)entry.getKey()).getValue())) {
                    affectedUsers.add(ceo.getLastModifier());
                    ceo.setLastModifier(targetUser);
                }
                this.removeUserByType(ceo, sourceUser, "collaborator");
                this.removeUserByType(ceo, sourceUser, "touched");
            }
            this.contentEntityObjectDao.save((EntityObject)ceo);
            return true;
        });
    }

    private void removeUserByType(ContentEntityObject ceo, ConfluenceUser sourceUser, String type) {
        EntityManager entityManager = this.getSessionOrThrowException();
        String user2ContentNamedQuery = "confluence.relation.user2content.get.simple";
        try {
            Query query = entityManager.createNamedQuery(user2ContentNamedQuery);
            query.setParameter("source", (Object)sourceUser);
            query.setParameter("target", (Object)ceo);
            query.setParameter("relationName", (Object)type);
            List collaboratorEntities = query.getResultList();
            if (collaboratorEntities.size() == 1) {
                entityManager.remove(collaboratorEntities.get(0));
            } else if (collaboratorEntities.size() > 1) {
                throw new Exception(String.format("Found more than one collaborator entity for user %s and ceo %s. Will be skipped. Entities found: %s", sourceUser.getName(), ceo.getId(), collaboratorEntities.size()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private EntityManager getSessionOrThrowException() {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        if (entityManager == null) {
            throw new NullPointerException("Could not anonymize page history. Hibernate session is NULL.");
        }
        return entityManager;
    }
}

