/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DCCommentChanger
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final CommentManager commentManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    public DCCommentChanger(@ComponentImport PageManager pageManager, CommentManager commentManager, TransactionTemplate transactionTemplate) {
        super(pageManager);
        this.commentManager = commentManager;
        this.transactionTemplate = transactionTemplate;
    }

    public String getType() {
        return "text";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            ArrayList<DCIFieldChangerValue> resultList = Lists.newArrayList(new DCIFieldChangerValue[0]);
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                String commentBody = comment.getBodyAsString();
                if (!StringUtils.isNotBlank((CharSequence)commentBody)) continue;
                resultList.add((DCIFieldChangerValue)new DCFieldChangerValue(commentBody));
            }
            return resultList;
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                this.transactionTemplate.execute(() -> {
                    Comment changedComment = this.commentManager.getComment(comment.getId());
                    boolean isCommentChanged = false;
                    for (Map.Entry entry : oldNewValueMap.entrySet()) {
                        String commentBody = changedComment.getBodyAsString();
                        if (!commentBody.contains(((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                        changedComment.setBodyAsString((String)entry.getValue());
                        isCommentChanged = true;
                    }
                    if (isCommentChanged) {
                        this.commentManager.saveContentEntity((ContentEntityObject)changedComment, this.SAVE_CONTEXT);
                    }
                    return true;
                });
            }
            return true;
        });
    }
}

