/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DCCommentAuthorChangerNew
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final CommentManager commentManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    public DCCommentAuthorChangerNew(@ComponentImport PageManager pageManager, CommentManager commentManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        super(pageManager);
        this.transactionTemplate = transactionTemplate;
        this.commentManager = commentManager;
        this.userAccessor = userAccessor;
    }

    public String getType() {
        return "user";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            HashSet<DCFieldChangerValue> resultList = new HashSet<DCFieldChangerValue>();
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                ConfluenceUser confluenceUser = comment.getCreator();
                if (confluenceUser == null) continue;
                resultList.add(new DCFieldChangerValue(confluenceUser.getKey().toString()));
            }
            return Lists.newArrayList(resultList);
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                this.transactionTemplate.execute(() -> {
                    String authorKey;
                    Comment changedComment = this.commentManager.getComment(comment.getId());
                    String string = authorKey = changedComment.getCreator() != null ? changedComment.getCreator().getKey().toString() : "";
                    if (StringUtils.isNotBlank((CharSequence)authorKey)) {
                        for (Map.Entry entry : oldNewValueMap.entrySet()) {
                            if (!authorKey.equals(((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                            ConfluenceUser sourceAuthor = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                            changedComment.setCreator(sourceAuthor);
                            this.commentManager.saveContentEntity((ContentEntityObject)changedComment, this.SAVE_CONTEXT);
                        }
                    }
                    return true;
                });
            }
            return true;
        });
    }
}

