/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DCAttachmentAuthorChanger
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final AttachmentManager attachmentManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    public DCAttachmentAuthorChanger(@ComponentImport PageManager pageManager, AttachmentManager attachmentManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        super(pageManager);
        this.attachmentManager = attachmentManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    public String getType() {
        return "user";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            HashSet<DCFieldChangerValue> resultList = new HashSet<DCFieldChangerValue>();
            List attachments = this.attachmentManager.getAllVersionsOfAttachments(ceo);
            for (Attachment attachment : attachments) {
                String lastModifierKey;
                String creatorKey = attachment.getCreator() != null ? attachment.getCreator().getKey().toString() : "";
                String string = lastModifierKey = attachment.getLastModifier() != null ? attachment.getLastModifier().getKey().toString() : "";
                if (StringUtils.isNotBlank((CharSequence)creatorKey)) {
                    resultList.add(new DCFieldChangerValue(creatorKey));
                }
                if (!StringUtils.isNotBlank((CharSequence)lastModifierKey)) continue;
                resultList.add(new DCFieldChangerValue(lastModifierKey));
            }
            return Lists.newArrayList(resultList);
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            List attachments = this.attachmentManager.getAllVersionsOfAttachments(ceo);
            for (Attachment attachment : attachments) {
                Attachment changedAttach = this.attachmentManager.getAttachment(attachment.getId());
                for (Map.Entry entry : oldNewValueMap.entrySet()) {
                    ConfluenceUser source = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                    if (source == null || changedAttach.getCreator() == null || !StringUtils.equalsIgnoreCase((CharSequence)changedAttach.getCreator().getKey().toString(), (CharSequence)((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                    changedAttach.setCreator(source);
                }
            }
            return true;
        });
    }
}

