/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.gdpr.datacleaner.model.DCConfluenceContentObject;
import de.actonic.gdpr.shared.datacleaner.model.IDCContentObject;
import de.actonic.gdpr.shared.datacleaner.model.template.IDCQueryParam;
import de.actonic.gdpr.shared.datacleaner.service.IDCCustomSearchIterator;
import de.actonic.gdpr.shared.general.model.GDPRUserModel;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;

public class DCCqlCustomSearchIterator
implements IDCCustomSearchIterator {
    private static final int MAX_SEARCH_RESULTS = 100;
    private IDCQueryParam queryParam;
    private Integer current;
    private Integer total;
    private Integer pageCount;
    private List<AbstractPage> pages = null;
    private ListIterator<AbstractPage> pageIterator;
    private final CqlManager cqlManager;

    public DCCqlCustomSearchIterator(CqlManager cqlManager) {
        this.cqlManager = cqlManager;
    }

    public void init(IDCQueryParam queryParam, GDPRUserModel user) throws Exception {
        this.queryParam = queryParam;
        this.current = 0;
        this.total = StringUtils.isBlank((CharSequence)queryParam.getType()) || StringUtils.equalsIgnoreCase((CharSequence)queryParam.getType(), (CharSequence)"cql") ? this.cqlManager.getIssuesCount(queryParam.getQuery()) : this.cqlManager.getIssueCountV2(queryParam.getQuery());
    }

    public Boolean hasNext() {
        if (this.pages == null || this.pageCount >= this.pages.size()) {
            this.updatePages();
        }
        return this.current < this.total;
    }

    public Boolean hasNextInCurrentScope() {
        return this.pageCount < this.pages.size();
    }

    public IDCContentObject next() {
        AbstractPage abstractPage = this.pageIterator.next();
        Integer n = this.pageCount;
        Integer n2 = this.pageCount = Integer.valueOf(this.pageCount + 1);
        n = this.current;
        n2 = this.current = Integer.valueOf(this.current + 1);
        return DCConfluenceContentObject.builder().ceo((ContentEntityObject)abstractPage).build();
    }

    public Integer total() {
        return this.total;
    }

    private void updatePages() {
        this.pageCount = 0;
        this.pages = StringUtils.isBlank((CharSequence)this.queryParam.getType()) || StringUtils.equalsIgnoreCase((CharSequence)this.queryParam.getType(), (CharSequence)"cql") ? this.cqlManager.getContentFromCql(this.queryParam.getQuery(), this.current, 100, true) : this.cqlManager.getContentFromCqlV2(this.queryParam.getQuery(), this.current, 100, true);
        this.pageIterator = this.pages.listIterator();
    }
}

