/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.manager;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCAttachmentAuthorChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCBodyContentChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCCommentAuthorChangerNew;
import de.actonic.gdpr.datacleaner.service.changer.DCCommentChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCCreatorUpdaterChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCLikeChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCTitleChanger;
import de.actonic.gdpr.datacleaner.service.changer.DCWatcherChangerNew;
import de.actonic.gdpr.shared.datacleaner.manager.IDCChangerFieldManager;
import de.actonic.gdpr.shared.datacleaner.model.DCKeyValueModel;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.IDCFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.sharedchanger.IDCSharedObjectChanger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DCChangerFieldManager
implements IDCChangerFieldManager {
    @ComponentImport
    private final I18nResolver i18n;
    private final DCTitleChanger dcTitleChanger;
    private final DCLikeChanger dcLikeChanger;
    private final DCWatcherChangerNew dcWatcherChangerNew;
    private final DCCreatorUpdaterChanger dcCreatorUpdaterChanger;
    private final DCCommentChanger dcCommentChanger;
    private final DCCommentAuthorChangerNew dcCommentAuthorChangerNew;
    private final DCBodyContentChanger dcBodyContentChanger;
    private final DCAttachmentAuthorChanger dcAttachmentAuthorChanger;
    private final List<String> textFields = Lists.newArrayList("title", "body", "comment");
    private final List<String> userFields = Lists.newArrayList("author", "comment-author", "attach-author", "like", "watcher");

    @Autowired
    public DCChangerFieldManager(I18nResolver i18n, DCTitleChanger dcTitleChanger, DCLikeChanger dcLikeChanger, DCWatcherChangerNew dcWatcherChangerNew, DCCreatorUpdaterChanger dcCreatorUpdaterChanger, DCCommentChanger dcCommentChanger, DCCommentAuthorChangerNew dcCommentAuthorChangerNew, DCBodyContentChanger dcBodyContentChanger, DCAttachmentAuthorChanger dcAttachmentAuthorChanger) {
        this.i18n = i18n;
        this.dcTitleChanger = dcTitleChanger;
        this.dcLikeChanger = dcLikeChanger;
        this.dcWatcherChangerNew = dcWatcherChangerNew;
        this.dcCreatorUpdaterChanger = dcCreatorUpdaterChanger;
        this.dcCommentChanger = dcCommentChanger;
        this.dcCommentAuthorChangerNew = dcCommentAuthorChangerNew;
        this.dcBodyContentChanger = dcBodyContentChanger;
        this.dcAttachmentAuthorChanger = dcAttachmentAuthorChanger;
    }

    public List<DCKeyValueModel> getTextFields() {
        return this.textFields.stream().map(this::getTextFieldDescriptor).collect(Collectors.toList());
    }

    public List<DCKeyValueModel> getUserFields() {
        return this.userFields.stream().map(this::getUserFieldDescriptor).collect(Collectors.toList());
    }

    public List<String> getAllContentFieldNames() {
        return ListUtils.union(this.textFields, this.userFields);
    }

    public List<DCKeyValueModel> getSharedObjectFields() {
        return null;
    }

    public List<String> getAllSharedObjectFieldNames() {
        return null;
    }

    public Map<String, IDCFieldChanger> getFieldChangers() {
        HashMap<String, IDCFieldChanger> changerMap = new HashMap<String, IDCFieldChanger>();
        changerMap.put("title", this.dcTitleChanger);
        changerMap.put("body", this.dcBodyContentChanger);
        changerMap.put("author", this.dcCreatorUpdaterChanger);
        changerMap.put("comment", this.dcCommentChanger);
        changerMap.put("comment-author", this.dcCommentAuthorChangerNew);
        changerMap.put("like", this.dcLikeChanger);
        changerMap.put("watcher", this.dcWatcherChangerNew);
        changerMap.put("attach-author", this.dcAttachmentAuthorChanger);
        return changerMap;
    }

    public Map<String, IDCSharedObjectChanger> getSharedObjectChangers() {
        return null;
    }

    private DCKeyValueModel getTextFieldDescriptor(String key) {
        return DCKeyValueModel.builder().key(key).value(this.i18n.getText("data-cleaner.fields.text.value." + key)).desc(this.i18n.getText("data-cleaner.fields.text.desc." + key)).build();
    }

    private DCKeyValueModel getUserFieldDescriptor(String key) {
        return DCKeyValueModel.builder().key(key).value(this.i18n.getText("data-cleaner.fields.user.value." + key)).desc(this.i18n.getText("data-cleaner.fields.user.desc." + key)).build();
    }
}

