/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.scheduling;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.announcement.service.AnnouncementHistoryService;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRBadRequestException;
import de.actonic.gdpr.shared.general.model.GDPRVersionType;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class CleanAnnouncementRecycleBinJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(CleanAnnouncementRecycleBinJob.class);
    private final AnnouncementService announcementService;
    private final AnnouncementHistoryService announcementHistoryService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager GDPRSettingsManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private static final Long INTERVAL_CLEAN = 2592000000L;

    public CleanAnnouncementRecycleBinJob(AnnouncementService announcementService, AnnouncementHistoryService announcementHistoryService, UserAccessor userAccessor, GDPRSettingsManager GDPRSettingsManager2, TransactionTemplate transactionTemplate) {
        this.announcementService = announcementService;
        this.announcementHistoryService = announcementHistoryService;
        this.userAccessor = userAccessor;
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.transactionTemplate = transactionTemplate;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        String userName = this.GDPRSettingsManager.getRunTasksFromUser() == null ? "" : this.GDPRSettingsManager.getRunTasksFromUser();
        ConfluenceUser serviceUser = this.userAccessor.getUserByName(userName);
        if (serviceUser == null) {
            throw new GDPRBadRequestException("Canceled because there is no service user defined");
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)serviceUser);
        this.transactionTemplate.execute(() -> {
            this.announcementService.getAnnouncementsByTypes(new String[]{GDPRVersionType.TRASH.getType()}).stream().filter(announcement -> new Date().getTime() - announcement.getModificationDate().getTime() >= INTERVAL_CLEAN).forEach(announcement -> {
                this.announcementService.cleanTrashById(announcement.getId().intValue());
                this.announcementHistoryService.deleteHistoryByAnnouncementId(announcement.getId().intValue());
            });
            return null;
        });
        log.debug(logHelper.stop());
        return JobRunnerResponse.success((String)"Successfully");
    }
}

