/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.actonic.confluence.gdpr.util.HttpServletRequestUtils;
import de.actonic.gdpr.announcement.model.AnnouncementUserUpdateRequestModel;
import de.actonic.gdpr.shared.announcement.service.AnnouncementHistoryService;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/announcements-for-user")
@Produces(value={"application/json"})
@Component
public class UserAnnouncementsRest {
    private static final Logger log = LoggerFactory.getLogger(UserAnnouncementsRest.class);
    private final String GDPR_ANONYMOUS_ANNOUNCING = "gdpr-anonymous-announcing";
    private final AnnouncementService announcementService;
    private final AnnouncementHistoryService announcementHistoryService;

    @Autowired
    public UserAnnouncementsRest(AnnouncementService announcementService, AnnouncementHistoryService announcementHistoryService) {
        this.announcementService = announcementService;
        this.announcementHistoryService = announcementHistoryService;
    }

    @GET
    @Path(value="/")
    @AnonymousAllowed
    public Response getAnnouncementsForUser(@QueryParam(value="type") String type, @QueryParam(value="parentContentKey") String parentContentKey, @CookieParam(value="gdpr-anonymous-announcing") String cookieAnnouncements) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List announcementModels = this.announcementService.getAnnouncementsForUser(cookieAnnouncements, type, parentContentKey);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementModels)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/{id}")
    @AnonymousAllowed
    public Response updateAnnouncementForUser(@PathParam(value="id") int id, @RequestBody AnnouncementUserUpdateRequestModel requestModel, @Context HttpServletRequest httpServletRequest) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        String ip = HttpServletRequestUtils.getRealIpAddress(httpServletRequest);
        this.announcementHistoryService.updateAnnouncementForUser(requestModel.getAnswer(), requestModel.getQuestionnaire(), Integer.valueOf(id), ip);
        log.debug(logHelper.stop());
        return Response.ok().build();
    }
}

