/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.rest;

import de.actonic.gdpr.shared.announcement.model.AnnouncementModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementStatisticExportModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncingHistorySearchResultModel;
import de.actonic.gdpr.shared.announcement.service.AnnouncementHistoryService;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import java.io.File;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/announcements-statistics")
@Produces(value={"application/json"})
@Component
public class AnnouncementsStatisticRest {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementsStatisticRest.class);
    private final AnnouncementService announcementService;
    private final AnnouncementHistoryService announcementHistoryService;

    @Autowired
    public AnnouncementsStatisticRest(AnnouncementService announcementService, AnnouncementHistoryService announcementHistoryService) {
        this.announcementService = announcementService;
        this.announcementHistoryService = announcementHistoryService;
    }

    @GET
    @Path(value="/")
    public Response getAnnouncementsStatistics(@QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit, @QueryParam(value="userName") String userName, @QueryParam(value="version") Integer version, @QueryParam(value="announcingId") Integer announcingId, @QueryParam(value="partName") String partName, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="orderBy") String orderBy) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncingHistorySearchResultModel result = this.announcementHistoryService.getAnnouncementsStatistics(page, limit, userName, version, announcingId, fromDate, toDate, orderBy, partName);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteAnnouncementsStatistic(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.deleteAnnouncementsStatistic(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/export")
    @Produces(value={"text/plain"})
    public Response exportAnnouncementsStatistics(AnnouncementStatisticExportModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            File file = this.announcementHistoryService.exportAnnouncementStatistic(requestModel);
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\""));
            log.debug(logHelper.stop());
            return response.build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/user")
    public Response getUsersAnnouncementsStatistics() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List result = this.announcementService.getUsersAnnouncementsStatistics();
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

