/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.actonic.gdpr.shared.announcement.model.AnnouncementDraftModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementImportModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementTemplateModel;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.model.GDPRPublishModel;
import de.actonic.gdpr.shared.general.model.GDPRSearchResultModel;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/announcements")
@Produces(value={"application/json"})
@Component
public class AnnouncementsRest {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementsRest.class);
    private final AnnouncementService announcementService;

    @Autowired
    public AnnouncementsRest(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    @GET
    @Path(value="/")
    @AnonymousAllowed
    public Response getAnnouncements(@QueryParam(value="announcementType") String announcementType, @QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit, @QueryParam(value="name") String name, @QueryParam(value="isFullMatchByName") boolean isFullMatchByName, @QueryParam(value="status") Boolean isEnable, @QueryParam(value="type") String type, @QueryParam(value="groups") String groups, @QueryParam(value="content") String content, @QueryParam(value="lastModifier") String lastModifier, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="style") String style, @QueryParam(value="sortByStatus") String sortByStatus, @QueryParam(value="sortByTemplateName") String sortByTemplateName, @QueryParam(value="sortByParentContent") String sortByParentContent, @QueryParam(value="sortByCanView") String sortByCanView, @QueryParam(value="sortByResponseStatus") String sortByResponseStatus) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            GDPRSearchResultModel result = this.announcementService.getAnnouncements(announcementType, page, limit, name, isFullMatchByName, type, isEnable, content, groups, style, lastModifier, fromDate, toDate, orderBy, sortByStatus, sortByTemplateName, sortByParentContent, sortByCanView, sortByResponseStatus);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        AnnouncementModel announcementModel = this.announcementService.getAnnouncement(id);
        log.debug(logHelper.stop());
        return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementModel)).build();
    }

    @GET
    @Path(value="/{id}/draft")
    public Response getDraftAnnouncementByParentId(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementDraftModel draftAnnouncement = this.announcementService.getDraftAnnouncementByParentId(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)draftAnnouncement)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}/versions")
    public Response getAnnouncementVersions(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List announcementModel = this.announcementService.getAnnouncementVersions(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/import")
    public Response importAnnouncements(List<AnnouncementImportModel> announcementModels) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List result = this.announcementService.importAnnouncements(announcementModels);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/export/{id}")
    public Response exportAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel result = this.announcementService.exportAnnouncementById(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonDisableHtmlEscaping().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}/versions/count")
    public Response getAnnouncementVersionsCount(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            log.debug(logHelper.stop());
            return Response.ok((Object)this.announcementService.getAnnouncementVersionsCount(id)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/")
    public Response createAnnouncement() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        AnnouncementModel announcement = this.announcementService.createSimpleAnnouncement();
        log.debug(logHelper.stop());
        return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcement)).build();
    }

    @POST
    @Path(value="/{id}/publish")
    public Response publishAnnouncement(@PathParam(value="id") int id, @RequestBody GDPRPublishModel publishAnnouncement) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.publishAnnouncement(id, publishAnnouncement);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/{id}")
    public Response updateAnnouncement(@PathParam(value="id") int id, @RequestBody AnnouncementModel announcingModelRequest) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            announcingModelRequest.setId(Integer.valueOf(id));
            AnnouncementModel announcementModel = this.announcementService.updateAnnouncing(announcingModelRequest);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="{id}/status")
    @Produces(value={"application/json"})
    public Response updateStatus(@PathParam(value="id") int id, @QueryParam(value="isActive") boolean isActive) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcingModel = this.announcementService.updateAnnouncementStatus(id, isActive);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.announcementService.deleteAnnouncing(id);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/revert")
    public Response revertAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.revertAnnouncement(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/restore")
    @XsrfProtectionExcluded
    public Response restoreAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.restoreAnnouncement(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/restoreAll")
    @XsrfProtectionExcluded
    public Response restoreAllAnnouncements() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List announcementModels = this.announcementService.restoreAllAnnouncement();
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModels)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/from-template/{id}")
    public Response createTemplateAnnouncement(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.createTemplateAnnouncing(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/from-template/{id}/preview")
    public Response getTemplateAnnouncementPreview(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementModel announcementModel = this.announcementService.getTemplateAnnouncingPreview(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)announcementModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/template/collection")
    public Response getTemplateAnnouncements(@QueryParam(value="name") String name, @QueryParam(value="type") String types, @QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            GDPRSearchResultModel templateAnnouncements = this.announcementService.getTemplateAnnouncements(name, types, page, limit);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)templateAnnouncements)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/template/{id}")
    public Response getTemplateAnnouncement(@PathParam(value="id") Long templateId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementTemplateModel templateAnnouncement = this.announcementService.getTemplateAnnouncement(templateId);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)templateAnnouncement)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/groups")
    public Response getAnnouncementGroups(@QueryParam(value="name") String name) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List announcementGroups = this.announcementService.getGroups(name);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementGroups)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/parent-content")
    public Response getAnnouncementSpaces(@QueryParam(value="name") String name) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            Map announcementParentContent = this.announcementService.getParentContent(name);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementParentContent)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/types")
    public Response getAnnouncementTypes() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List announcementParentContent = this.announcementService.getAnnouncementTypes();
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)announcementParentContent)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/template/recent")
    public Response getRecentTemplateAnnouncements() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)this.announcementService.getRecentTemplateAnnouncements())).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

