/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.rest;

import de.actonic.gdpr.shared.announcement.model.AnnouncementCheckPermissionModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementCheckPermissionRequestModel;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/announcement-permission-check")
@Produces(value={"application/json"})
@Component
public class AnnouncementPermissionCheck {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementPermissionCheck.class);
    private final AnnouncementService announcementService;

    @Autowired
    public AnnouncementPermissionCheck(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    @POST
    @Path(value="/")
    public Response checkPermission(@RequestBody AnnouncementCheckPermissionRequestModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            AnnouncementCheckPermissionModel result = this.announcementService.checkPermission(requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

