/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import de.actonic.gdpr.announcement.ao.AnnouncementHistoryEntity;
import de.actonic.gdpr.announcement.dao.AnnouncementHistoryDao;
import de.actonic.gdpr.announcement.manager.ConfluenceUserNameConvertManager;
import de.actonic.gdpr.shared.announcement.manager.IAnnouncementHistoryManager;
import de.actonic.gdpr.shared.announcement.model.AnnouncementHistoryModel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceIAnnouncementHistoryManager
implements IAnnouncementHistoryManager {
    private final AnnouncementHistoryDao announcementHistoryDao;
    private final ConfluenceUserNameConvertManager userNameConvertManager;

    @Autowired
    public ConfluenceIAnnouncementHistoryManager(AnnouncementHistoryDao announcementHistoryDao, ConfluenceUserNameConvertManager userNameConvertManager) {
        this.announcementHistoryDao = announcementHistoryDao;
        this.userNameConvertManager = userNameConvertManager;
    }

    public int getAcceptedCount(int announcingId) {
        return this.announcementHistoryDao.getAcceptedCount(announcingId);
    }

    public int getDeclinedCount(int announcingId) {
        return this.announcementHistoryDao.getDeclinedCount(announcingId);
    }

    public boolean isUserAcceptedAnnouncing(String userKey, int announcingId) {
        return this.announcementHistoryDao.isUserAcceptedAnnouncing(userKey, announcingId);
    }

    public List<AnnouncementHistoryModel> getSharedAnnouncingHistoryModels(String userName, int announcing) {
        String userKey;
        String string = userKey = StringUtils.isNotBlank((CharSequence)userName) ? this.userNameConvertManager.convertUserNameToUserKey(userName) : "";
        List<AnnouncementHistoryModel> announcingHistoryModels = StringUtils.isNotBlank((CharSequence)userKey) && announcing != 0 ? this.filterAnnouncingHistoryItemsByUserAndAnnouncingId(userKey, announcing) : (StringUtils.isNotBlank((CharSequence)userKey) ? this.filterAnnouncingHistoryItemsByUser(userKey) : (announcing != 0 ? this.filterAnnouncingHistoryItemsByAnnouncingId(announcing) : this.getAnnouncingHistoryItems()));
        return announcingHistoryModels;
    }

    private List<AnnouncementHistoryModel> filterAnnouncingHistoryItemsByUserAndAnnouncingId(String userKey, int id) {
        return this.entitiesToModels(this.announcementHistoryDao.getAllEntitiesByUserAndAnnouncingId(userKey, id));
    }

    private List<AnnouncementHistoryModel> filterAnnouncingHistoryItemsByUser(String userKey) {
        return this.entitiesToModels(this.announcementHistoryDao.getAllEntitiesByUser(userKey));
    }

    private List<AnnouncementHistoryModel> filterAnnouncingHistoryItemsByAnnouncingId(int id) {
        return this.entitiesToModels(this.announcementHistoryDao.getAllEntitiesByAnnouncingId(id));
    }

    private List<AnnouncementHistoryModel> getAnnouncingHistoryItems() {
        return this.entitiesToModels(this.announcementHistoryDao.getAllEntities());
    }

    private List<AnnouncementHistoryModel> entitiesToModels(List<AnnouncementHistoryEntity> entities) {
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public AnnouncementHistoryModel getHistoryByIdAndUser(int announcingId, String userName) {
        AnnouncementHistoryEntity entity = this.announcementHistoryDao.getHistoryByIdAndUser(announcingId, userName);
        return this.entityToModel(entity);
    }

    public List<AnnouncementHistoryModel> getHistoryByUser(String userName) {
        return Arrays.stream(this.announcementHistoryDao.getHistoryByUser(userName)).map(this::entityToModel).collect(Collectors.toList());
    }

    public void clearAnnouncing(int announcingId) {
        this.announcementHistoryDao.clearAnnouncing(announcingId);
    }

    public String getQueResponse(int announcingId, String userKey) {
        return this.announcementHistoryDao.getQueResponse(announcingId, userKey);
    }

    private AnnouncementHistoryModel entityToModel(AnnouncementHistoryEntity entity) {
        if (entity == null) {
            return null;
        }
        return AnnouncementHistoryModel.builder().announcingId(entity.getAnnouncingId()).name(entity.getName()).user(entity.getUser()).answer(entity.getAnswer()).response(entity.getQuestionnaire()).timeStamp(entity.getTimeStamp()).version(entity.getVersion()).ip(entity.getIp()).build();
    }

    public boolean isVisitedAlready(int announcingId, String userName) {
        return this.announcementHistoryDao.isVisitedAlready(announcingId, userName);
    }

    public AnnouncementHistoryModel createEntity(int announcingId, Integer version, String name, String userKey, String answer, String questionnaire, String ip) {
        return this.entityToModel(this.announcementHistoryDao.createEntity(announcingId, version, name, userKey, answer, questionnaire, ip));
    }

    public List<AnnouncementHistoryModel> getFilteredHistoryAnnouncements(String userName, Integer announcing, Integer version, Date fromDate, Date toDate) {
        return this.entitiesToModels(this.announcementHistoryDao.getFilteredHistoryAnnouncements(userName, announcing, version, fromDate, toDate));
    }

    public void clearByAnnouncementIds(List<Integer> announcementIds) {
        this.announcementHistoryDao.clearByAnnouncementIds(announcementIds);
    }
}

