/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.shared.announcement.manager.IAnnouncementCacheManager;
import de.actonic.gdpr.shared.announcement.model.AnnouncementModel;
import de.actonic.gdpr.shared.announcement.service.AnnouncementService;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceCacheManager
implements IAnnouncementCacheManager {
    private final Cache<String, String> cache;

    @Autowired
    public ConfluenceCacheManager(@ComponentImport CacheManager cacheManager) {
        this.cache = cacheManager.getCache(AnnouncementService.class.getName());
        this.removeAll();
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey((Object)key);
    }

    public List<AnnouncementModel> get(String key) {
        if (this.containsKey(key)) {
            String data = (String)this.cache.get((Object)key);
            return (List)GDPRJsonUtils.fromJson((String)data, (Type)GDPRJsonUtils.ANNOUNCEMENT_LIST_TYPE);
        }
        return Lists.newArrayList(new AnnouncementModel[0]);
    }

    public void remove(String key) {
        this.cache.remove((Object)key);
    }

    public void put(String key, List<AnnouncementModel> value) {
        this.cache.put((Object)key, (Object)GDPRJsonUtils.toJson(value));
    }

    public void cleanUserCache(String userKey) {
        this.cache.getKeys().stream().filter(key -> key.contains(userKey)).forEach(arg_0 -> this.cache.remove(arg_0));
    }

    public void removeBulk(String ... keys) {
        Set uniqueKeys = Arrays.stream(keys).filter(Objects::nonNull).flatMap(key -> Arrays.stream(key.split(", "))).map(String::trim).collect(Collectors.toSet());
        List<String> filteredKeys = this.cache.getKeys().stream().filter(k -> uniqueKeys.stream().filter(Objects::nonNull).anyMatch(k::contains)).collect(Collectors.toList());
        filteredKeys.forEach(arg_0 -> this.cache.remove(arg_0));
    }

    public int size() {
        return this.cache.getKeys().size();
    }

    public List<String> getKeys() {
        return (List)this.cache.getKeys();
    }
}

