/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.announcement.ao.AnnouncementEntity;
import de.actonic.gdpr.general.manager.GDPRAbstractEntityDao;
import de.actonic.gdpr.shared.general.model.GDPRVersionType;
import de.actonic.gdpr.shared.general.util.GDPRAssertUtils;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementDao
extends GDPRAbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementDao.class);

    @Autowired
    public AnnouncementDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public AnnouncementEntity getById(int id) {
        AnnouncementEntity entity = this.getFirstByField(AnnouncementEntity.class, "ID", id);
        return entity;
    }

    public AnnouncementEntity createEntity(boolean isActive, Date startDate, Date endDate, String name, String type, String style, String creator, Date creationDate, Date modificationDate, String lastModifier, String group, boolean isQuestionnaire, boolean isAnonymous, String windowSize, String accept, String decline, boolean isPinned, String title, String content, Long pageId, String body, String spaces, boolean isShowInPeriod, Integer version, String announcementType, Set<String> contributors) {
        AnnouncementEntity entity = (AnnouncementEntity)this.ao.create(AnnouncementEntity.class, new DBParam[0]);
        entity.setIsActive(isActive);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setName(name);
        entity.setType(type);
        entity.setStyle(style);
        entity.setCreator(creator);
        entity.setCreationDate(creationDate);
        entity.setModificationDate(modificationDate);
        entity.setLastModifier(lastModifier);
        entity.setGroup(group);
        entity.setIsQuestionnaire(isQuestionnaire);
        entity.setIsAnonymous(isAnonymous);
        entity.setWindowSize(windowSize);
        entity.setAccept(accept);
        entity.setDecline(decline);
        entity.setIsPinned(isPinned);
        entity.setTitle(title);
        entity.setContent(content);
        entity.setPageId(pageId);
        entity.setBody(body);
        entity.setSpaces(spaces);
        entity.setIsShowInPeriod(isShowInPeriod);
        entity.setVersion(version);
        entity.setAnnouncementType(announcementType);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.save();
        return entity;
    }

    public AnnouncementEntity updateEntity(boolean isFullUpdate, int id, Boolean isActive, Date startDate, Date endDate, String name, String type, String style, String group, Boolean isQuestionnaire, Boolean isAnonymous, String windowSize, String accept, String decline, Boolean isPinned, String creator, Date creationDate, String lastModifier, String title, String body, String spaces, Boolean showInPeriod, Integer version, String announcementType, Integer parentId, Set<String> contributors, String comment) {
        AnnouncementEntity entity = this.getFirstByField(AnnouncementEntity.class, "ID", id);
        AnnouncementDao.setIfNotNull(isActive, entity::setIsActive);
        AnnouncementDao.setIfNotNull(startDate, entity::setStartDate);
        AnnouncementDao.setIfNotNull(endDate, entity::setEndDate);
        AnnouncementDao.setIfNotNull(name, entity::setName);
        AnnouncementDao.setIfNotNull(type, entity::setType);
        AnnouncementDao.setIfNotNull(style, entity::setStyle);
        AnnouncementDao.setIfNotNull(group, entity::setGroup);
        AnnouncementDao.setIfNotNull(isQuestionnaire, entity::setIsQuestionnaire);
        AnnouncementDao.setIfNotNull(isAnonymous, entity::setIsAnonymous);
        AnnouncementDao.setIfNotNull(windowSize, entity::setWindowSize);
        AnnouncementDao.setIfNotNull(accept, entity::setAccept);
        AnnouncementDao.setIfNotNull(decline, entity::setDecline);
        AnnouncementDao.setIfNotNull(isPinned, entity::setIsPinned);
        AnnouncementDao.setIfNotNull(title, entity::setTitle);
        AnnouncementDao.setIfNotNull(body, entity::setBody);
        AnnouncementDao.setIfNotNull(spaces, entity::setSpaces);
        AnnouncementDao.setIfNotNull(showInPeriod, entity::setIsShowInPeriod);
        if (isFullUpdate) {
            entity.setCreator(creator);
            entity.setCreationDate(creationDate);
            entity.setModificationDate(new Date());
            entity.setLastModifier(lastModifier);
            entity.setVersion(version);
            entity.setAnnouncementType(announcementType);
            entity.setParentId(parentId);
            GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
            entity.setComment(comment);
        }
        entity.save();
        return entity;
    }

    public AnnouncementEntity updateEntity(int id, String announcementType, String lastModifier, String name) {
        AnnouncementEntity entity = (AnnouncementEntity)this.ao.get(AnnouncementEntity.class, (Object)id);
        entity.setAnnouncementType(announcementType);
        entity.setLastModifier(lastModifier);
        entity.setModificationDate(new Date());
        entity.setName(name);
        entity.save();
        return entity;
    }

    public AnnouncementEntity updateStatus(int id, boolean isActive) {
        AnnouncementEntity entity = this.getFirstByField(AnnouncementEntity.class, "ID", id);
        entity.setIsActive(isActive);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        AnnouncementEntity entity = this.getFirstByField(AnnouncementEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public List<AnnouncementEntity> getAllEntities() {
        AnnouncementEntity[] entities = (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().order("ID ASC"));
        return Lists.newArrayList(entities);
    }

    public List<AnnouncementEntity> getActiveEntities() {
        Query query = Query.select().order("ID ASC");
        Date now = new Date();
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        sb.append("IS_ACTIVE = ?");
        values.add(Boolean.TRUE);
        sb.append(" AND ANNOUNCEMENT_TYPE = ?");
        values.add(GDPRVersionType.CURRENT.getType());
        sb.append(" AND (START_DATE IS NULL OR START_DATE <= ?)");
        values.add(now);
        sb.append(" AND (END_DATE IS NULL OR END_DATE >= ?)");
        values.add(now);
        query.setWhereClause(sb.toString());
        query.setWhereParams(values.toArray());
        AnnouncementEntity[] entities = (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, query);
        return Lists.newArrayList(entities);
    }

    public List<AnnouncementEntity> getPinnedEntities() {
        Date now = new Date();
        AnnouncementEntity[] entities = (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_PINNED = ? AND (START_DATE IS NULL OR START_DATE <= ?)AND (END_DATE IS NULL OR END_DATE >= ?)", new Object[]{Boolean.TRUE, Boolean.TRUE, now, now}).order("ID ASC"));
        return Lists.newArrayList(entities);
    }

    public Integer getActiveAnnouncementSize() {
        return this.ao.count(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ?", new Object[]{Boolean.TRUE}));
    }

    public AnnouncementEntity[] getLoginFormEntities() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND STYLE = ?", new Object[]{Boolean.TRUE, "block-login-form"}));
    }

    public AnnouncementEntity[] getEntitiesByGroup(String groupName) {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND GROUP = ?", new Object[]{Boolean.TRUE, groupName}));
    }

    public AnnouncementEntity[] getEntitiesWithoutGroup() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND (GROUP IS NULL OR GROUP = ?)", new Object[]{Boolean.TRUE, ""}));
    }

    public AnnouncementEntity createSimpleEntity(String announcementType, String creator, Set<String> contributors, Integer version, Boolean isActive, String type, String style, String size, boolean isQuestionnaire, boolean isAnonymous, boolean isShowInPeriod, String group, String parentContent) {
        AnnouncementEntity entity = (AnnouncementEntity)this.ao.create(AnnouncementEntity.class, new DBParam[0]);
        entity.setAnnouncementType(announcementType);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.setVersion(version);
        entity.setCreator(creator);
        entity.setCreationDate(new Date());
        entity.setIsActive(isActive);
        entity.setLastModifier(creator);
        entity.setModificationDate(new Date());
        entity.setType(type);
        entity.setStyle(style);
        entity.setWindowSize(size);
        entity.setIsQuestionnaire(isQuestionnaire);
        entity.setIsAnonymous(isAnonymous);
        entity.setIsShowInPeriod(isShowInPeriod);
        entity.setGroup(group);
        entity.setSpaces(parentContent);
        entity.save();
        return entity;
    }

    public AnnouncementEntity createAnnouncementDraft(Boolean isActive, Date startDate, Date endDate, String name, String type, String style, String group, Boolean isQuestionnaire, Boolean isAnonymous, String windowSize, String accept, String decline, Boolean isPinned, String creator, String title, String body, String projects, Boolean showInPeriod, Integer version, String announcementType, Integer parentId, Set<String> contributors) {
        AnnouncementEntity entity = (AnnouncementEntity)this.ao.create(AnnouncementEntity.class, new DBParam[0]);
        AnnouncementDao.setIfNotNull(isActive, entity::setIsActive);
        AnnouncementDao.setIfNotNull(startDate, entity::setStartDate);
        AnnouncementDao.setIfNotNull(endDate, entity::setEndDate);
        AnnouncementDao.setIfNotNull(name, entity::setName);
        AnnouncementDao.setIfNotNull(type, entity::setType);
        AnnouncementDao.setIfNotNull(style, entity::setStyle);
        AnnouncementDao.setIfNotNull(group, entity::setGroup);
        AnnouncementDao.setIfNotNull(isQuestionnaire, entity::setIsQuestionnaire);
        AnnouncementDao.setIfNotNull(isAnonymous, entity::setIsAnonymous);
        AnnouncementDao.setIfNotNull(windowSize, entity::setWindowSize);
        AnnouncementDao.setIfNotNull(accept, entity::setAccept);
        AnnouncementDao.setIfNotNull(decline, entity::setDecline);
        AnnouncementDao.setIfNotNull(isPinned, entity::setIsPinned);
        AnnouncementDao.setIfNotNull(title, entity::setTitle);
        AnnouncementDao.setIfNotNull(body, entity::setBody);
        AnnouncementDao.setIfNotNull(projects, entity::setSpaces);
        AnnouncementDao.setIfNotNull(creator, entity::setCreator);
        entity.setCreationDate(new Date());
        entity.setModificationDate(new Date());
        AnnouncementDao.setIfNotNull(showInPeriod, entity::setIsShowInPeriod);
        AnnouncementDao.setIfNotNull(version, entity::setVersion);
        AnnouncementDao.setIfNotNull(announcementType, entity::setAnnouncementType);
        AnnouncementDao.setIfNotNull(parentId, entity::setParentId);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.save();
        return entity;
    }

    public AnnouncementEntity[] getDraftAnnouncement(int parentId) {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("PARENT_ID = ? AND ANNOUNCEMENT_TYPE = ?", new Object[]{parentId, GDPRVersionType.DRAFT.getType()}).order("ID ASC"));
    }

    public AnnouncementEntity[] getChildrenAnnouncement(int id) {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("PARENT_ID = ?", new Object[]{id}).order("ID ASC"));
    }

    public AnnouncementEntity[] getAnnouncementsByTypes(List<String> types) {
        Query query = Query.select().order("ID ASC");
        query.setWhereClause(AnnouncementDao.createWhereClause(types, ",", "ANNOUNCEMENT_TYPE IN (", ") "));
        query.setWhereParams(types.toArray());
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, query);
    }

    public void deleteAllByParentId(int parentId) {
        AnnouncementEntity[] entities = this.getChildrenAnnouncement(parentId);
        if (entities != null && entities.length > 0) {
            this.ao.delete((RawEntity[])entities);
        }
    }

    public AnnouncementEntity updateContributors(int id, Set<String> contributors) {
        AnnouncementEntity entity = (AnnouncementEntity)this.ao.get(AnnouncementEntity.class, (Object)id);
        entity.setContributors(GDPRJsonUtils.toJson(contributors));
        entity.save();
        return entity;
    }

    public AnnouncementEntity[] getFilteredAnnouncements(String name, boolean isFullMatchByName, List<String> types, Boolean isEnable, String style, String lastModifier, List<String> announcementTypes, Date fromDate, Date toDate) {
        Query query = Query.select();
        StringBuilder sb = new StringBuilder();
        sb.append(AnnouncementDao.createWhereClause(announcementTypes, ",", "ANNOUNCEMENT_TYPE IN (", ") "));
        ArrayList<String> values = new ArrayList<String>(announcementTypes);
        if (name != null) {
            if (!isFullMatchByName) {
                name = "%" + name + "%";
            }
            sb.append(" AND LOWER(\"NAME\") LIKE LOWER(?)");
            values.add(name);
        }
        if (!types.isEmpty()) {
            sb.append(AnnouncementDao.createWhereClause(types, ",", " AND STYLE IN (", ") "));
            values.addAll(types);
        }
        if (isEnable != null) {
            sb.append(" AND IS_ACTIVE = ?");
            values.add((String)((Object)isEnable));
        }
        if (lastModifier != null) {
            sb.append(" AND LAST_MODIFIER = ?");
            values.add(lastModifier);
        }
        if (fromDate != null) {
            sb.append(" AND MODIFICATION_DATE >= ?");
            values.add((String)((Object)fromDate));
        }
        if (toDate != null) {
            sb.append(" AND MODIFICATION_DATE <= ?");
            values.add((String)((Object)toDate));
        }
        if (style != null) {
            sb.append(" AND STYLE = ?");
            values.add(style);
        }
        query.setWhereClause(sb.toString());
        query.setWhereParams(values.toArray());
        AnnouncementEntity[] result = (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, query);
        return result;
    }

    public List<AnnouncementEntity> getByIds(List<Integer> ids) {
        if (ids.isEmpty()) {
            return Lists.newArrayList(new AnnouncementEntity[0]);
        }
        return GDPRAssertUtils.partition(ids, (int)1000).stream().map(announcementIds -> {
            Query query = Query.select().order("ID ASC");
            query.setWhereClause(AnnouncementDao.createWhereClause(announcementIds, ",", "ID IN (", ") "));
            query.setWhereParams(announcementIds.toArray());
            AnnouncementEntity[] entities = (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, query);
            return Lists.newArrayList(entities);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public AnnouncementEntity[] getAnnouncementsByName(String name) {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("LOWER(\"NAME\") LIKE LOWER(?)", new Object[]{name}).order("ID ASC"));
    }

    public AnnouncementEntity[] getNotAnonymousCurrentPinnedEntities() {
        String param = "%pin%";
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ? AND STYLE LIKE ? ", new Object[]{Boolean.TRUE, Boolean.FALSE, GDPRVersionType.CURRENT.getType(), param}));
    }

    public AnnouncementEntity[] getAnonymousCurrentPinnedEntities() {
        String param = "%pin%";
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ? AND STYLE LIKE ?", new Object[]{Boolean.TRUE, Boolean.TRUE, GDPRVersionType.CURRENT.getType(), param}));
    }

    public AnnouncementEntity[] getCurrentLoginFormEntities() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND STYLE LIKE ? AND ANNOUNCEMENT_TYPE = ?", new Object[]{Boolean.TRUE, "%block-login-form%", GDPRVersionType.CURRENT.getType()}));
    }

    public AnnouncementEntity[] getNotAnonymousCurrentWindowAnnouncements() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ? AND (STYLE = ? OR STYLE = ? OR STYLE = ? OR STYLE = ?)", new Object[]{Boolean.TRUE, Boolean.FALSE, GDPRVersionType.CURRENT.getType(), "center", "bottom", "pin-center", "pin-bottom"}));
    }

    public AnnouncementEntity[] getAnonymousCurrentWindowAnnouncements() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ? AND (STYLE = ? OR STYLE = ? OR STYLE = ? OR STYLE = ?)", new Object[]{Boolean.TRUE, Boolean.TRUE, GDPRVersionType.CURRENT.getType(), "center", "bottom", "pin-center", "pin-bottom"}));
    }

    public AnnouncementEntity[] getCurrentAnnouncements() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("ANNOUNCEMENT_TYPE = ? ", new Object[]{GDPRVersionType.CURRENT.getType()}));
    }

    public AnnouncementEntity[] getTrashAnnouncements() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("ANNOUNCEMENT_TYPE = ? ", new Object[]{GDPRVersionType.TRASH.getType()}));
    }

    public AnnouncementEntity[] getCurrentLoginFormAnnouncements() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("ANNOUNCEMENT_TYPE = ? AND IS_ACTIVE = ? AND STYLE LIKE ?", new Object[]{GDPRVersionType.CURRENT.getType(), Boolean.TRUE, "%block-login-form%"}));
    }

    public AnnouncementEntity[] getCurrentNotAnonymousEntitiesByGroups(List<String> groupNames) {
        Query query = Query.select();
        StringBuilder sb = new StringBuilder();
        sb.append(AnnouncementDao.createWhereClause(groupNames, ",", "GROUP IN (", ") "));
        ArrayList<String> values = new ArrayList<String>(groupNames);
        sb.append("AND IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ?");
        values.add((String)((Object)Boolean.FALSE));
        values.add(GDPRVersionType.CURRENT.getType());
        query.setWhereClause(sb.toString());
        query.setWhereParams(values.toArray());
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, query);
    }

    public AnnouncementEntity[] getCurrentNotAnonymousEntitiesWithoutGroup() {
        return (AnnouncementEntity[])this.ao.find(AnnouncementEntity.class, Query.select().where("IS_ANONYMOUS = ? AND ANNOUNCEMENT_TYPE = ? AND (GROUP IS NULL OR GROUP = ?)", new Object[]{Boolean.FALSE, GDPRVersionType.CURRENT.getType(), ""}));
    }
}

