/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.upgrade.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import de.actonic.confluence.gdpr.component.service.ProfileVisibilityService;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UpgradeTask002
implements ActiveObjectsUpgradeTask {
    private final ProfileVisibilityService profileVisibilityService;

    public UpgradeTask002(ProfileVisibilityService profileVisibilityService) {
        this.profileVisibilityService = profileVisibilityService;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        ArrayList<ConfluenceUser> confluenceUsers = Lists.newArrayList(new ConfluenceUser[0]);
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List groups = userAccessor.getGroupsAsList();
        for (Group group : groups) {
            for (ConfluenceUser temp : userAccessor.getMembers(group)) {
                if (confluenceUsers.contains(temp)) continue;
                confluenceUsers.add(temp);
            }
        }
        for (ConfluenceUser confluenceUser : confluenceUsers) {
            String customHideFrom = this.profileVisibilityService.getUserHideFrom(confluenceUser.getName());
            if (StringUtils.isNotBlank((CharSequence)customHideFrom)) {
                this.profileVisibilityService.setUserProfileVisibilitySettings(confluenceUser, Boolean.valueOf(customHideFrom));
            }
            this.profileVisibilityService.removeUserHideFrom(confluenceUser.getName());
        }
    }
}

