/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import de.actonic.confluence.gdpr.component.service.ProfileVisibilityService;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServletFilterForProfileVisibilityRestrictions
implements Filter {
    private ProfileVisibilityService profileVisibilityService;
    private final Pattern pattern = Pattern.compile("~([^\\/]+)\\/*([^\\/]*)");

    @Autowired
    public ServletFilterForProfileVisibilityRestrictions(ProfileVisibilityService profileVisibilityService) {
        this.profileVisibilityService = profileVisibilityService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String state = this.profileVisibilityService.getState();
        if (!StringUtils.equalsIgnoreCase((CharSequence)state, (CharSequence)this.profileVisibilityService.ENABLE_FOR_ALL)) {
            boolean isUserProfileLink = true;
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            String profileName = "";
            String searchString = URLDecoder.decode(httpServletRequest.getRequestURI(), "UTF-8");
            Matcher matcher = this.pattern.matcher(searchString);
            if (matcher.find()) {
                profileName = matcher.group(1);
                String pageTitle = matcher.group(2);
                if (StringUtils.isNotBlank((CharSequence)pageTitle)) {
                    isUserProfileLink = false;
                }
            } else {
                profileName = URLDecoder.decode(httpServletRequest.getParameter("username"), "UTF-8");
            }
            if (isUserProfileLink && !this.profileVisibilityService.canUserSeeProfile(applicationUser, profileName)) {
                String redirectString = httpServletRequest.getContextPath() + "/plugins/actonic-gdpr/forbidden.action";
                httpServletResponse.sendRedirect(redirectString);
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

