/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.confluence.gdpr.component.service.AccessStatisticsService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServletFilterForContentRest
implements Filter {
    private final AccessStatisticsService accessStatisticsService;
    private final UserNameConvertManager userNameConvertManager;

    @Autowired
    public ServletFilterForContentRest(AccessStatisticsService accessStatisticsService, UserNameConvertManager userNameConvertManager) {
        this.accessStatisticsService = accessStatisticsService;
        this.userNameConvertManager = userNameConvertManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String url = httpServletRequest.getRequestURL().toString();
        String pageIdAsString = url.substring(url.lastIndexOf(47) + 1);
        if (StringUtils.isNotBlank((CharSequence)pageIdAsString)) {
            long pageId = 0L;
            try {
                pageId = Long.parseLong(pageIdAsString);
                if (pageId != 0L) {
                    ConfluenceUser applicationUser;
                    String remoteIpAddress = httpServletRequest.getHeader("X-FORWARDED-FOR");
                    if (StringUtils.isBlank((CharSequence)remoteIpAddress)) {
                        remoteIpAddress = httpServletRequest.getHeader("x-forwarded-for");
                    }
                    if (StringUtils.isBlank((CharSequence)remoteIpAddress)) {
                        remoteIpAddress = httpServletRequest.getRemoteAddr();
                    }
                    String userName = (applicationUser = AuthenticatedUserThreadLocal.get()) == null ? "[anonymous]" : applicationUser.getName();
                    String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
                    this.accessStatisticsService.addAccessStatisticsEntity(userKey, remoteIpAddress, pageId, "rest");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

