/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.SecurityCheckManager;
import de.actonic.confluence.gdpr.component.manager.UserPickerManager;
import de.actonic.confluence.gdpr.model.json.IdTextModel;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.confluence.gdpr.util.Maps;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/picker")
@Produces(value={"application/json"})
public class PickerRest {
    private static final Logger log = LoggerFactory.getLogger(PickerRest.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final GroupManager groupManager;
    private final SecurityCheckManager securityCheckManager;
    private final UserPickerManager userPickerManager;
    private final IGDPRUserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public PickerRest(UserAccessor userAccessor, SpaceManager spaceManager, PageManager pageManager, GroupManager groupManager, SecurityCheckManager securityCheckManager, UserPickerManager userPickerManager, IGDPRUserManager userManager, I18nResolver i18n) {
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.groupManager = groupManager;
        this.securityCheckManager = securityCheckManager;
        this.userPickerManager = userPickerManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="/user")
    @Produces(value={"application/json"})
    public Response searchUsers(@QueryParam(value="query") String query) {
        if (!this.securityCheckManager.isUserConfluenceAdmin(AuthenticatedUserThreadLocal.get()).booleanValue()) {
            String errorMsg = "Only Confluence administrators could use /user search";
            log.debug(errorMsg);
            HashMap<String, String> errorMsgObj = Maps.getMapData("error", errorMsg);
            return Response.status((int)403).entity((Object)new Gson().toJson(errorMsgObj)).build();
        }
        if (query != null) {
            try {
                List<IdTextModel> userModels = this.userPickerManager.searchUsers(query);
                return Response.ok((Object)new Gson().toJson(userModels)).build();
            }
            catch (ServiceException e) {
                log.error("Error while searching for user", (Throwable)e);
                return Response.status((int)500).build();
            }
        }
        String errorMsg = "Query parameter could not be empty";
        log.debug(errorMsg);
        HashMap<String, String> errorMsgObj = Maps.getMapData("error", errorMsg);
        return Response.status((int)400).entity((Object)new Gson().toJson(errorMsgObj)).build();
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getGroups(@QueryParam(value="q") String query) {
        try {
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            Pager pager = this.groupManager.getGroups();
            ArrayList<Group> users = Lists.newArrayList(new Group[0]);
            while (!pager.onLastPage()) {
                users.addAll(pager.getCurrentPage());
            }
            if (pager.onLastPage()) {
                users.addAll(pager.getCurrentPage());
            }
            List idTextModels = users.stream().filter(user -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)user.getName(), (CharSequence)query)).map(user -> new IdTextModel(user.getName(), user.getName(), "", "")).collect(Collectors.toList());
            Gson gson = new Gson();
            return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
        }
        catch (EntityException e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/gdpr-groups")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getGdprGroups(@QueryParam(value="q") String query) {
        try {
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            List groupNamesForUserName = this.userAccessor.getGroupNamesForUserName(confluenceUser.getName());
            List idTextModels = groupNamesForUserName.stream().filter(groupName -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)query)).map(groupName -> new IdTextModel((String)groupName, (String)groupName, "", "")).collect(Collectors.toList());
            Gson gson = new Gson();
            return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/spaces")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getSpaces(@QueryParam(value="q") String query) {
        if (!this.securityCheckManager.isUserHasPermissions().booleanValue()) {
            return Response.status((int)403).entity((Object)"Access denied").build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        List idTextModels = spaces.stream().filter(space -> {
            String[] queryParams = query.split(",");
            return Arrays.stream(queryParams).anyMatch(param -> StringUtils.containsIgnoreCase((CharSequence)space.getKey(), (CharSequence)param) || StringUtils.containsIgnoreCase((CharSequence)space.getName(), (CharSequence)param));
        }).map(space -> new IdTextModel(space.getKey(), space.getName(), space.getUrlPath(), "")).collect(Collectors.toList());
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
    }

    @GET
    @Path(value="/pages")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getPages(@QueryParam(value="q") String query, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.securityCheckManager.isUserHasPermissions().booleanValue()) {
            return Response.status((int)403).entity((Object)"Access denied").build();
        }
        List<IdTextModel> idTextModels = Lists.newArrayList(new IdTextModel[0]);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            List pages = this.pageManager.getPages(space, true);
            idTextModels = pages.stream().filter(page -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)page.getTitle(), (CharSequence)query)).map(page -> new IdTextModel(String.valueOf(page.getId()), page.getTitle(), page.getUrlPath(), "")).collect(Collectors.toList());
        }
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
    }
}

