/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.IntroManager;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/intro")
@Produces(value={"application/json"})
public class IntroRest {
    private static final Logger logger = LoggerFactory.getLogger(IntroRest.class);
    private final IntroManager introManager;

    @Autowired
    public IntroRest(IntroManager introManager) {
        this.introManager = introManager;
    }

    @GET
    @Path(value="/{module}/{userName}")
    public Response isIntroShowed(@PathParam(value="module") String module, @PathParam(value="userName") String userName) {
        try {
            boolean isIntroShowed = this.introManager.isIntroShowed(module, userName);
            return Response.ok().entity((Object)new Gson().toJson((Object)isIntroShowed)).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/{module}/{userName}")
    public Response flushIntro(@PathParam(value="module") String module, @PathParam(value="userName") String userName) {
        try {
            this.introManager.deleteIntroMarker(module, userName);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }
}

