/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.actonic.confluence.gdpr.component.service.AnnouncingHistoryService;
import de.actonic.confluence.gdpr.component.service.AnnouncingHistorySortService;
import de.actonic.confluence.gdpr.component.service.AnnouncingService;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.util.HttpServletRequestUtils;
import de.actonic.confluence.gdpr.util.Maps;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/announcing")
@Produces(value={"application/json"})
public class AnnouncingRest {
    private static final Logger log = LoggerFactory.getLogger(AnnouncingRest.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String GDPR_ANONYMOUS_ANNOUNCING = "gdpr-anonymous-announcing";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final GDPRSettingsManager GDPRSettingsManager;
    private final AnnouncingService announcingService;
    private final AnnouncingHistoryService announcingHistoryService;
    private final AnnouncingHistorySortService announcingHistorySortService;
    private final IGDPRUserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public AnnouncingRest(GDPRSettingsManager GDPRSettingsManager2, AnnouncingService announcingService, AnnouncingHistoryService announcingHistoryService, AnnouncingHistorySortService announcingHistorySortService, IGDPRUserManager userManager, I18nResolver i18n) {
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.announcingService = announcingService;
        this.announcingHistoryService = announcingHistoryService;
        this.announcingHistorySortService = announcingHistorySortService;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="/next")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getNextAnnouncing(@CookieParam(value="gdpr-anonymous-announcing") String cookieAnnouncings) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        AnnouncingModel announcingModel = this.announcingService.getNextAnnouncingItemForUser(applicationUser, cookieAnnouncings);
        return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getAnnouncers(@QueryParam(value="query") String query) {
        try {
            List<AnnouncingModel> announcingModels = this.announcingService.getAnnouncingItemsByPartName(query);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson(announcingModels)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getAnnouncing(@PathParam(value="id") int id) {
        try {
            AnnouncingModel announcingModel = this.announcingService.getAnnouncingItem(id);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteAnnouncing(@PathParam(value="id") int id) {
        try {
            this.announcingService.deleteAnnouncingItem(id);
            return Response.ok().build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response createAnnouncers(@FormParam(value="isActive") boolean isActive, @FormParam(value="startDate") String startDate, @FormParam(value="endDate") String endDate, @FormParam(value="name") String name, @FormParam(value="type") String type, @FormParam(value="style") String style, @FormParam(value="group") String group, @FormParam(value="isQuestionnaire") boolean isQuestionnaire, @FormParam(value="isAnonymous") boolean isAnonymous, @FormParam(value="windowSize") String windowSize, @FormParam(value="accept") String accept, @FormParam(value="decline") String decline, @FormParam(value="isPinned") boolean isPinned, @FormParam(value="title") String title, @FormParam(value="content") String content, @FormParam(value="pageId") Long pageId, @FormParam(value="body") String body) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            AnnouncingModel announcingModel = this.announcingService.createAnnouncing(applicationUser, isActive, this.parseDate(startDate), this.parseDate(endDate), name, type, style, group, isQuestionnaire, isAnonymous, windowSize, accept, decline, isPinned, title, content, pageId, body);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateAnnouncers(@PathParam(value="id") int id, @FormParam(value="isActive") boolean isActive, @FormParam(value="startDate") String startDate, @FormParam(value="endDate") String endDate, @FormParam(value="name") String name, @FormParam(value="type") String type, @FormParam(value="style") String style, @FormParam(value="group") String group, @FormParam(value="isQuestionnaire") boolean isQuestionnaire, @FormParam(value="isAnonymous") boolean isAnonymous, @FormParam(value="windowSize") String windowSize, @FormParam(value="accept") String accept, @FormParam(value="decline") String decline, @FormParam(value="title") String title, @FormParam(value="isPinned") boolean isPinned, @FormParam(value="content") String content, @FormParam(value="pageId") Long pageId, @FormParam(value="body") String body) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            AnnouncingModel announcingModel = this.announcingService.updateAnnouncing(id, applicationUser, isActive, this.parseDate(startDate), this.parseDate(endDate), name, type, style, group, isQuestionnaire, isAnonymous, windowSize, accept, decline, isPinned, title, content, pageId, body);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/template/{id}")
    public Response createTemplateAnnouncement(@PathParam(value="id") int id) {
        try {
            AnnouncingModel announcingModel = this.announcingService.createTemplateAnnoucing(id);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/status/{id}")
    @Produces(value={"application/json"})
    public Response updateStatus(@PathParam(value="id") int id, @FormParam(value="isActive") boolean isActive) {
        try {
            AnnouncingModel announcingModel = this.announcingService.updateStatus(id, isActive);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/accept/{id}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response acceptAnnouncing(@PathParam(value="id") int id, @FormParam(value="questionnaire") String questionnaire, @Context HttpServletRequest httpServletRequest) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        String ip = HttpServletRequestUtils.getRealIpAddress(httpServletRequest);
        this.announcingHistoryService.acceptAnnouncing(id, applicationUser, questionnaire, ip);
        return Response.ok().build();
    }

    @POST
    @Path(value="/cancel/{id}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response cancelAnnouncing(@PathParam(value="id") int id, @FormParam(value="questionnaire") String questionnaire, @Context HttpServletRequest httpServletRequest) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        String ip = HttpServletRequestUtils.getRealIpAddress(httpServletRequest);
        this.announcingHistoryService.cancelAnnouncing(id, applicationUser, questionnaire, ip);
        return Response.ok().build();
    }

    @POST
    @Path(value="/clear/{id}")
    @Produces(value={"application/json"})
    public Response clearAnnouncing(@PathParam(value="id") int id) {
        try {
            AnnouncingModel announcingModel = this.announcingService.clearAnnouncing(id);
            return Response.ok((Object)this.getGsonForAnnouncingModel().toJson((Object)announcingModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/html")
    @Produces(value={"application/json"})
    public Response clearAnnouncing(@FormParam(value="html") String html) {
        boolean isHtmlValid = this.announcingService.isHtmlValid(html);
        return Response.ok((Object)new Gson().toJson(Maps.getMapData("status", isHtmlValid))).build();
    }

    @POST
    @Path(value="/filter")
    public Response filterEvents(@FormParam(value="page") Integer page, @FormParam(value="userName") String userName, @FormParam(value="announcing") int announcing, @FormParam(value="fromDate") long fromDate, @FormParam(value="toDate") long toDate, @FormParam(value="orderBy") String orderBy) {
        try {
            int end;
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            List<Object> announcingHistoryModels = new ArrayList();
            announcingHistoryModels = StringUtils.isNotBlank((CharSequence)userName) && announcing != 0 ? this.announcingHistoryService.filterAnnouncingHistoryItemsByUserAndAnnouncingId(userName, announcing, fromDate, toDate) : (StringUtils.isNotBlank((CharSequence)userName) ? this.announcingHistoryService.filterAnnouncingHistoryItemsByUser(userName, fromDate, toDate) : (announcing != 0 ? this.announcingHistoryService.filterAnnouncingHistoryItemsByAnnouncingId(announcing, fromDate, toDate) : this.announcingHistoryService.getAnnouncingHistoryItems(fromDate, toDate)));
            this.announcingHistorySortService.sortEvents(announcingHistoryModels, orderBy);
            if (page == null) {
                page = 0;
            }
            int offset = this.GDPRSettingsManager.getRowsPerPage();
            int start = (page - 1) * offset;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + offset) > announcingHistoryModels.size()) {
                end = announcingHistoryModels.size();
            }
            int totalPages = (int)Math.ceil((double)announcingHistoryModels.size() / (double)offset);
            announcingHistoryModels = announcingHistoryModels.subList(start, end);
            HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
            resultMap.put("items", (Serializable)((Object)announcingHistoryModels));
            resultMap.put("totalPages", Integer.valueOf(totalPages));
            resultMap.put("page", page);
            return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/export")
    @Produces(value={"text/plain"})
    public Response getAll(@QueryParam(value="page") Integer page, @QueryParam(value="userName") String userName, @QueryParam(value="announcing") int announcing, @QueryParam(value="fromDate") long fromDate, @QueryParam(value="toDate") long toDate, @QueryParam(value="orderBy") String orderBy) {
        try {
            this.userManager.getUserOrThrowException("Only administrators can export announcements");
            List<Object> announcingHistoryModels = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                announcingHistoryModels = this.announcingHistoryService.filterAnnouncingHistoryItemsByUser(userName, fromDate, toDate);
            }
            if (announcing != 0) {
                announcingHistoryModels = this.announcingHistoryService.filterAnnouncingHistoryItemsByAnnouncingId(announcing, fromDate, toDate);
            }
            if (announcing == 0 && StringUtils.isBlank((CharSequence)userName)) {
                announcingHistoryModels = this.announcingHistoryService.getAnnouncingHistoryItems(fromDate, toDate);
            }
            this.announcingHistorySortService.sortEvents(announcingHistoryModels, orderBy);
            String fileName = "announcing-statistics";
            File file = File.createTempFile(fileName, "csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Name", "User", "Date", "IP", "Result", "Response"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            Pattern p = Pattern.compile("(<([^>]+)>)");
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            announcingHistoryModels.forEach(announcingHistoryModel -> {
                try {
                    csvFilePrinter.printRecord(new Object[]{announcingHistoryModel.getName(), p.matcher(announcingHistoryModel.getUser()).replaceAll(""), formatter.format(announcingHistoryModel.getTimeStamp()), announcingHistoryModel.getIp(), announcingHistoryModel.getAnswer(), announcingHistoryModel.getResponse()});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/pinned")
    @AnonymousAllowed
    public Response getPinnedAnnouncements() {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        List<AnnouncingModel> announcingModels = this.announcingService.getPinnedAnnouncements(applicationUser);
        return Response.ok((Object)this.getGsonForAnnouncingModel().toJson(announcingModels)).build();
    }

    @PUT
    @Path(value="/{action}/{id}")
    @AnonymousAllowed
    public Response updatePinnedAnnouncement(@PathParam(value="action") String action, @PathParam(value="id") int id, @FormParam(value="questionnaire") String questionnaire) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        if (applicationUser != null) {
            boolean result = this.announcingHistoryService.updatePinnedAnnouncing(action, id, applicationUser, questionnaire);
            return Response.ok((Object)new Gson().toJson(Maps.getMapData("success", result))).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Gson().toJson((Object)"You are not authenticated")).build();
    }

    private Gson getGsonForAnnouncingModel() {
        return new GsonBuilder().setDateFormat(DATE_FORMAT).create();
    }

    private Date parseDate(String str) {
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

