/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LikeChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(LikeChanger.class);
    @ComponentImport
    private final LikeManager likeManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final PageManager pageManager;

    @Autowired
    public LikeChanger(LikeManager likeManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate, PageManager pageManager) {
        this.likeManager = likeManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            ArrayList<String> resultList = Lists.newArrayList(new String[0]);
            List likes = this.likeManager.getLikes(ceo);
            for (Like like : likes) {
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(like.getUsername());
                if (confluenceUser == null || resultList.contains(confluenceUser.getKey().toString())) continue;
                resultList.add(confluenceUser.getKey().toString());
            }
            return resultList;
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            List likes = this.likeManager.getLikes(ceo);
            for (Like like : likes) {
                ConfluenceUser target = this.userAccessor.getUserByName(like.getUsername());
                if (target == null) continue;
                for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                    if (!target.getKey().toString().equals(entry.getKey())) continue;
                    this.likeManager.removeLike(ceo, (User)target);
                    ConfluenceUser source = this.userAccessor.getUserByName((String)entry.getValue());
                    this.likeManager.addLike(ceo, (User)source);
                }
            }
            return true;
        });
    }
}

