/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DCWatcherChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(DCWatcherChanger.class);
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DCWatcherChanger(NotificationManager notificationManager, PageManager pageManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        this.notificationManager = notificationManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            ArrayList<String> resultList = Lists.newArrayList(new String[0]);
            List notifications = this.notificationManager.getNotificationsByContent(ceo);
            for (Notification notification : notifications) {
                if (notification.getReceiver() == null) continue;
                resultList.add(notification.getReceiver().getKey().toString());
            }
            return resultList;
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            List notifications = this.notificationManager.getNotificationsByContent(ceo);
            for (Notification notification : notifications) {
                String recieverName = notification.getReceiver().getKey().toString();
                if (!StringUtils.isNotBlank((CharSequence)recieverName)) continue;
                for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                    ConfluenceUser source;
                    if (!recieverName.equals(entry.getKey()) || (source = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()))) == null) continue;
                    notification.setReceiver(source);
                }
            }
            return true;
        });
    }

    protected List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ArrayList<ContentEntityObject> versions = Lists.newArrayList(new ContentEntityObject[0]);
        versions.add(versionPage);
        while ((versionPage = this.pageManager.getPreviousVersion(versionPage)) != null) {
            versions.add(versionPage);
        }
        return versions;
    }
}

