/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatorUpdaterChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(CreatorUpdaterChanger.class);
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final ContentEntityObjectDao contentEntityObjectDao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    protected EntityManagerProvider entityManagerProvider;

    @Autowired
    public CreatorUpdaterChanger(PageManager pageManager, UserAccessor userAccessor, ContentEntityObjectDao contentEntityObjectDao, TransactionTemplate transactionTemplate, EntityManagerProvider entityManagerProvider) {
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.transactionTemplate = transactionTemplate;
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            HashSet<String> resultList = new HashSet<String>();
            if (ceo.getCreator() != null) {
                resultList.add(ceo.getCreator().getKey().toString());
            }
            if (ceo.getLastModifier() != null) {
                resultList.add(ceo.getLastModifier().getKey().toString());
            }
            EntityManager entityManager = this.getSessionOrThrowException();
            try {
                String strQuery = "select re.sourceContent from User2ContentRelationEntity re where (re.relationName = :collaborator or re.relationName = :touched) and re.targetContent = :targetContent";
                Query query = entityManager.createQuery(strQuery);
                query.setParameter("targetContent", (Object)ceo);
                query.setParameter("collaborator", (Object)"collaborator");
                query.setParameter("touched", (Object)"touched");
                List collaboratorEntities = query.getResultList();
                collaboratorEntities.stream().map(entity -> (ConfluenceUser)entity).forEach(user -> resultList.add(user.getKey().getStringValue()));
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
            return Lists.newArrayList(resultList);
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            ArrayList<ConfluenceUser> affectedUsers = Lists.newArrayList(new ConfluenceUser[0]);
            for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                ConfluenceUser sourceUser = this.userAccessor.getUserByKey(new UserKey((String)entry.getKey()));
                ConfluenceUser targetUser = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                if (ceo.getCreator() != null && StringUtils.equalsIgnoreCase((CharSequence)ceo.getCreator().getKey().toString(), (CharSequence)((CharSequence)entry.getKey()))) {
                    affectedUsers.add(ceo.getCreator());
                    ceo.setCreator(targetUser);
                }
                if (ceo.getLastModifier() != null && StringUtils.equalsIgnoreCase((CharSequence)ceo.getLastModifier().getKey().toString(), (CharSequence)((CharSequence)entry.getKey()))) {
                    affectedUsers.add(ceo.getLastModifier());
                    ceo.setLastModifier(targetUser);
                }
                this.removeUserByType(ceo, sourceUser, "collaborator");
                this.removeUserByType(ceo, sourceUser, "touched");
            }
            this.contentEntityObjectDao.save((EntityObject)ceo);
            return true;
        });
    }

    private void removeUserByType(ContentEntityObject ceo, ConfluenceUser sourceUser, String type) {
        EntityManager entityManager = this.getSessionOrThrowException();
        String user2ContentNamedQuery = "confluence.relation.user2content.get.simple";
        try {
            Query query = entityManager.createNamedQuery(user2ContentNamedQuery);
            query.setParameter("source", (Object)sourceUser);
            query.setParameter("target", (Object)ceo);
            query.setParameter("relationName", (Object)type);
            List collaboratorEntities = query.getResultList();
            if (collaboratorEntities.size() == 1) {
                entityManager.remove(collaboratorEntities.get(0));
            } else if (collaboratorEntities.size() > 1) {
                throw new Exception(String.format("Found more than one collaborator entity for user %s and ceo %s. Will be skipped. Entities found: %s", sourceUser.getName(), ceo.getId(), collaboratorEntities.size()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private EntityManager getSessionOrThrowException() {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        if (entityManager == null) {
            throw new NullPointerException("Could not anonymize page history. Hibernate session is NULL.");
        }
        return entityManager;
    }

    protected List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ArrayList<ContentEntityObject> versions = Lists.newArrayList(new ContentEntityObject[0]);
        versions.add(versionPage);
        return versions;
    }
}

