/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(CommentChanger.class);
    private final PageManager pageManager;
    private final CommentManager commentManager;
    private final TransactionTemplate transactionTemplate;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    @Autowired
    public CommentChanger(@ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            ArrayList<String> resultList = Lists.newArrayList(new String[0]);
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                String commentBody = comment.getBodyAsString();
                if (!StringUtils.isNotBlank((CharSequence)commentBody)) continue;
                resultList.add(commentBody);
            }
            return resultList;
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                this.transactionTemplate.execute(() -> {
                    Comment changedComment = this.commentManager.getComment(comment.getId());
                    boolean isCommentChanged = false;
                    for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                        String commentBody = changedComment.getBodyAsString();
                        if (!commentBody.contains((CharSequence)entry.getKey())) continue;
                        changedComment.setBodyAsString((String)entry.getValue());
                        isCommentChanged = true;
                    }
                    if (isCommentChanged) {
                        this.commentManager.saveContentEntity((ContentEntityObject)changedComment, this.SAVE_CONTEXT);
                    }
                    return true;
                });
            }
            return true;
        });
    }
}

