/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentAuthorChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(AttachmentAuthorChanger.class);
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final AttachmentManager attachmentManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    @Autowired
    public AttachmentAuthorChanger(PageManager pageManager, AttachmentManager attachmentManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            HashSet<String> resultList = new HashSet<String>();
            List attachments = this.attachmentManager.getAllVersionsOfAttachments(ceo);
            for (Attachment attachment : attachments) {
                String lastModifierKey;
                String creatorKey = attachment.getCreator() != null ? attachment.getCreator().getKey().toString() : "";
                String string = lastModifierKey = attachment.getLastModifier() != null ? attachment.getLastModifier().getKey().toString() : "";
                if (StringUtils.isNotBlank((CharSequence)creatorKey)) {
                    resultList.add(creatorKey);
                }
                if (!StringUtils.isNotBlank((CharSequence)lastModifierKey)) continue;
                resultList.add(lastModifierKey);
            }
            return Lists.newArrayList(resultList);
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            List attachments = this.attachmentManager.getAllVersionsOfAttachments(ceo);
            for (Attachment attachment : attachments) {
                Attachment changedAttach = this.attachmentManager.getAttachment(attachment.getId());
                for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                    ConfluenceUser source = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                    if (source == null || changedAttach.getCreator() == null || !StringUtils.equalsIgnoreCase((CharSequence)changedAttach.getCreator().getKey().toString(), (CharSequence)((CharSequence)entry.getKey()))) continue;
                    changedAttach.setCreator(source);
                }
            }
            return true;
        });
    }
}

