/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerCreateTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionNotificationTypeEnum;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerQuickUserTemplateModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerPostFunctionService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerRuleService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskExecutionService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerService.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final I18nResolver i18n;
    private final DataCleanerTemplateService dataCleanerTemplateService;
    private final DataCleanerRuleService dataCleanerRuleService;
    private final DataCleanerPostFunctionService dataCleanerPostFunctionService;
    private final DataCleanerTaskService dataCleanerTaskService;
    private final DataCleanerTaskExecutionService dataCleanerTaskExecutionService;

    @Autowired
    public DataCleanerService(UserAccessor userAccessor, I18nResolver i18n, DataCleanerTemplateService dataCleanerTemplateService, DataCleanerRuleService dataCleanerRuleService, DataCleanerPostFunctionService dataCleanerPostFunctionService, DataCleanerTaskService dataCleanerTaskService, DataCleanerTaskExecutionService dataCleanerTaskExecutionService) {
        this.userAccessor = userAccessor;
        this.i18n = i18n;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
        this.dataCleanerRuleService = dataCleanerRuleService;
        this.dataCleanerPostFunctionService = dataCleanerPostFunctionService;
        this.dataCleanerTaskService = dataCleanerTaskService;
        this.dataCleanerTaskExecutionService = dataCleanerTaskExecutionService;
    }

    public DataCleanerTaskModel quickUserAnonymize(DataCleanerQuickUserTemplateModel templateModel) throws Exception {
        templateModel.setId(-1);
        templateModel.setName(this.i18n.getText("js-data-clean.template.uat.text.name") + " (" + (templateModel.getTemplateType().equals("user") ? templateModel.getSourceUsers() : "any user") + "->" + templateModel.getTargetUser() + ")");
        this.dataCleanerTemplateService.updateTemplate(-1, templateModel);
        String targetUserName = templateModel.getTargetUser();
        ConfluenceUser targetUser = this.userAccessor.getUserByName(targetUserName);
        String sourceUserNames = templateModel.getSourceUsers();
        String targetUserDisplayName = "not specified";
        String targetUserEmailAddress = "not specified";
        if (targetUser != null) {
            targetUserDisplayName = targetUser.getFullName();
            targetUserEmailAddress = targetUser.getEmail();
        }
        String finalTargetUserDisplayName = targetUserDisplayName;
        String finalTargetUserEmailAddress = targetUserEmailAddress;
        Arrays.stream(sourceUserNames.split(",")).forEach(sourceUserName -> {
            ConfluenceUser sourceUser = this.userAccessor.getUserByName(sourceUserName);
            if (StringUtils.containsIgnoreCase((CharSequence)templateModel.getTemplateType(), (CharSequence)"user") && sourceUser != null) {
                this.createRule(this.i18n.getText("js-data-clean.template.uat.name"), "user", "user", sourceUser.getName(), targetUserName);
                this.createRule(this.i18n.getText("js-data-clean.template.uat.mention"), "plain", "plain-text", "[~" + sourceUser.getName() + "]", "[~" + targetUserName + "]");
                this.createRule(this.i18n.getText("js-data-clean.template.uat.email"), "plain", "plain-text", sourceUser.getEmail(), finalTargetUserEmailAddress);
                this.createRule(this.i18n.getText("js-data-clean.template.uat.display"), "plain", "plain-text", sourceUser.getFullName(), finalTargetUserDisplayName);
                DataCleanerPostFunctionModel dataCleanerPostFunctionModel = new DataCleanerPostFunctionModel();
                dataCleanerPostFunctionModel.setName("Custom anonymizer");
                dataCleanerPostFunctionModel.setNotificationType(DataCleanerPostFunctionNotificationTypeEnum.CUSTOM_ANONYMIZER.getType());
                dataCleanerPostFunctionModel.setAnyRuleEnabled(true);
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("sourceUsers", sourceUserNames);
                parameters.put("targetUser", targetUserName);
                dataCleanerPostFunctionModel.setNotificationParameters(parameters);
                dataCleanerPostFunctionModel.setTemplateId(-1);
                this.dataCleanerPostFunctionService.createPostFunction(dataCleanerPostFunctionModel);
                if (templateModel.isDisableUsers()) {
                    this.userAccessor.deactivateUser((User)sourceUser);
                }
            }
            if (StringUtils.containsIgnoreCase((CharSequence)templateModel.getTemplateType(), (CharSequence)"ticket")) {
                this.createRule(this.i18n.getText("js-data-clean.template.uat.name"), "any-user", "user", "any-user-name", targetUserName);
                this.createRule(this.i18n.getText("js-data-clean.template.uat.mention"), "plain", "plain-text", "[~any-user-name]", "[~" + finalTargetUserEmailAddress + "]");
            }
        });
        DataCleanerCreateTaskModel taskModel = new DataCleanerCreateTaskModel();
        taskModel.setTemplateId(-1);
        taskModel.setTemplateType(templateModel.getTemplateType());
        taskModel.setType(templateModel.getTaskType());
        DataCleanerTaskModel dataCleanerTaskModel = this.dataCleanerTaskService.createTask(taskModel, templateModel);
        if (this.dataCleanerTaskService.hasTaskForStart()) {
            this.dataCleanerTaskExecutionService.executeIfExists();
        }
        return dataCleanerTaskModel;
    }

    private void createRule(String name, String searchType, String replaceType, String searchString, String replaceString) {
        DataCleanerRuleModel ruleModel = new DataCleanerRuleModel();
        ruleModel.setTemplateId(-1);
        ruleModel.setEnabled(true);
        ruleModel.setName(name);
        ruleModel.setSearchType(searchType);
        ruleModel.setReplaceType(replaceType);
        ruleModel.setSearchString(searchString);
        ruleModel.setReplaceString(replaceString);
        this.dataCleanerRuleService.createRule(ruleModel);
    }
}

