/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleaner3dPartyAddonModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleaner3dPartyAddonsStatusType;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleaner3dPartyAddonsManager;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleaner3dPartyAddonService {
    private static final Logger log = LoggerFactory.getLogger(DataCleaner3dPartyAddonService.class);
    private final DataCleaner3dPartyAddonsManager dataCleaner3dPartyAddonsManager;

    @Autowired
    public DataCleaner3dPartyAddonService(DataCleaner3dPartyAddonsManager dataCleaner3dPartyAddonsManager) {
        this.dataCleaner3dPartyAddonsManager = dataCleaner3dPartyAddonsManager;
    }

    public void doOnEventAnswer(Object params) {
        log.error("HAAALLELUUUUYAAAA");
        HashMap castedParams = (HashMap)params;
        String emitter = (String)castedParams.get("emitter");
        log.error(castedParams.keySet().toString());
        log.error(castedParams.values().toString());
        if (StringUtils.endsWithIgnoreCase((CharSequence)emitter, (CharSequence)"AnonymizationEventAnswer") || StringUtils.endsWithIgnoreCase((CharSequence)emitter, (CharSequence)"SearchEventAnswer")) {
            String anonymizerName = (String)castedParams.get("anonymizerName");
            String eventId = (String)castedParams.get("eventId");
            String statusMessage = (String)castedParams.get("statusMessage");
            Integer taskId = (Integer)castedParams.get("taskId");
            String eventType = emitter.replace("Answer", "");
            String statusString = (String)castedParams.get("status");
            DataCleaner3dPartyAddonsStatusType statusType = DataCleaner3dPartyAddonsStatusType.getValue(statusString);
            switch (statusType) {
                case STARTED: {
                    this.dataCleaner3dPartyAddonsManager.create(taskId, eventId, eventType, statusString, anonymizerName, statusMessage);
                    break;
                }
                case PROCESSING: 
                case FINISHED: 
                case FAILED: {
                    this.dataCleaner3dPartyAddonsManager.update(eventId, statusString, statusMessage);
                    break;
                }
                case UNDEFINED: {
                    log.error(String.format("Event '%s' from anonymizer '%s' has wrong status parameter, it will not be updated", eventId, anonymizerName));
                }
            }
        }
    }

    public void deleteHistoryByTaskId(Integer taskId) {
        this.dataCleaner3dPartyAddonsManager.deleteAllForTask(taskId);
    }

    public void validateEntitiesForTimeout() {
        List<DataCleaner3dPartyAddonModel> lostModels = this.dataCleaner3dPartyAddonsManager.getStillActiveAddonsAfter1H();
        for (DataCleaner3dPartyAddonModel model : lostModels) {
            this.dataCleaner3dPartyAddonsManager.update(model.getEventId(), DataCleaner3dPartyAddonsStatusType.TIMEOUT.getType(), "This task has been marked 'TIMEOUT' because there is no update due 1 hour. It may be changed, if addon will update status later.<br>Previous statusMessage is '" + model.getStatusMessage() + "'.");
        }
    }
}

