/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import de.actonic.confluence.gdpr.common.datacleaner.model.TaskRequestStatusEnum;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTaskDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskDao.class);

    @Autowired
    public DataCleanerTaskDao(ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerTaskEntity getActiveTaskForTemplate(int templateId) {
        return this.getFirstByQuery(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ? AND STATUS = ?", new Object[]{templateId, TaskRequestStatusEnum.IN_PROGRESS.getCode()}));
    }

    public List<DataCleanerTaskEntity> getHistoricalTasksForTemplate(int templateId) {
        return (List)this.ao.executeInTransaction(() -> Lists.newArrayList(this.ao.find(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ? AND (STATUS = ? OR STATUS = ? OR STATUS = ?)", new Object[]{templateId, TaskRequestStatusEnum.ABORTED.getCode(), TaskRequestStatusEnum.FINISHED.getCode(), TaskRequestStatusEnum.FAILED.getCode()}).order("ID ASC"))));
    }

    public DataCleanerTaskEntity getByTemplateId(int templateId) {
        return this.getLastByField(DataCleanerTaskEntity.class, "TEMPLATE_ID", templateId);
    }

    public DataCleanerTaskEntity getLastTask(Integer templateId) {
        return this.getLastByQuery(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ? AND (STATUS != ? OR STATUS != ?)", new Object[]{templateId, TaskRequestStatusEnum.ABORTED.getCode(), TaskRequestStatusEnum.FAILED.getCode()}));
    }

    public DataCleanerTaskEntity getById(int id) {
        return this.getFirstByField(DataCleanerTaskEntity.class, "ID", id);
    }

    public DataCleanerTaskEntity create(int templateId, int taskType, String creator, String meta) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = (DataCleanerTaskEntity)this.ao.create(DataCleanerTaskEntity.class, new DBParam[0]);
            entity.setTemplateId(templateId);
            entity.setCreator(creator);
            entity.setCreateDate(new Date());
            entity.setStatus(TaskRequestStatusEnum.NOT_STARTED.getCode());
            entity.setTaskType(taskType);
            entity.setMeta(meta);
            entity.setTaskMessage("Task queued");
            entity.save();
            return entity;
        });
    }

    public DataCleanerTaskEntity start(int templateId) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getByTemplateId(templateId);
            entity.setStatus(TaskRequestStatusEnum.IN_PROGRESS.getCode());
            entity.setStartDate(new Date());
            entity.save();
            return entity;
        });
    }

    public DataCleanerTaskEntity updateTaskByTemplateId(int templateId, int currentNum, int totalNum, String taskMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getByTemplateId(templateId);
            if (entity.getStatus() == TaskRequestStatusEnum.IN_PROGRESS.getCode()) {
                entity.setTaskCurrentNum(currentNum);
                entity.setTaskTotalNum(totalNum);
                entity.setTaskMessage(taskMessage);
                entity.setLastUpdateTime(System.currentTimeMillis());
                entity.save();
            }
            return entity;
        });
    }

    public DataCleanerTaskEntity updateTaskById(int taskId, int currentNum, int totalNum, String taskMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = (DataCleanerTaskEntity)this.ao.get(DataCleanerTaskEntity.class, (Object)taskId);
            if (entity.getStatus() == TaskRequestStatusEnum.IN_PROGRESS.getCode()) {
                entity.setTaskCurrentNum(currentNum);
                entity.setTaskTotalNum(totalNum);
                entity.setTaskMessage(taskMessage);
                entity.setLastUpdateTime(System.currentTimeMillis());
                entity.save();
            }
            return entity;
        });
    }

    public DataCleanerTaskEntity cancelTask(int taskId, String cancelMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getById(taskId);
            entity.setStatus(TaskRequestStatusEnum.ABORTED.getCode());
            entity.setEndDate(new Date());
            entity.setTaskMessage(cancelMessage);
            entity.save();
            return entity;
        });
    }

    public DataCleanerTaskEntity cancel(int templateId, String cancelMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getByTemplateId(templateId);
            entity.setStatus(TaskRequestStatusEnum.ABORTED.getCode());
            entity.setEndDate(new Date());
            entity.setTaskMessage(cancelMessage);
            entity.save();
            return entity;
        });
    }

    public DataCleanerTaskEntity failed(int templateId, String errorMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getByTemplateId(templateId);
            entity.setStatus(TaskRequestStatusEnum.FAILED.getCode());
            entity.setEndDate(new Date());
            entity.setTaskMessage(errorMessage);
            entity.save();
            return entity;
        });
    }

    public DataCleanerTaskEntity finish(int templateId, String finishMessage) {
        return (DataCleanerTaskEntity)this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getByTemplateId(templateId);
            entity.setStatus(TaskRequestStatusEnum.FINISHED.getCode());
            entity.setEndDate(new Date());
            entity.setTaskCurrentNum(entity.getTaskTotalNum());
            entity.setTaskMessage(finishMessage);
            entity.save();
            return entity;
        });
    }

    public void setLastUpdateTime(int taskId, Long lastUpdateTime) {
        this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getById(taskId);
            entity.setLastUpdateTime(lastUpdateTime);
            entity.save();
            return true;
        });
    }

    public void delete(int taskId) {
        this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = this.getById(taskId);
            this.ao.delete(new RawEntity[]{entity});
            return true;
        });
    }

    public DataCleanerTaskEntity getNextTaskForStart() {
        return this.getFirstByField(DataCleanerTaskEntity.class, "STATUS", TaskRequestStatusEnum.NOT_STARTED.getCode());
    }

    public List<DataCleanerTaskEntity> getTaskListForStart() {
        return this.getTaskListByQuery(TaskRequestStatusEnum.NOT_STARTED.getCode());
    }

    public List<DataCleanerTaskEntity> getTaskListByQuery(int status) {
        return Lists.newArrayList(this.ao.find(DataCleanerTaskEntity.class, Query.select().where("STATUS = ?", new Object[]{status}).order("ID ASC")));
    }

    public boolean hasTaskForTemplate(int templateId) {
        int count = (Integer)this.ao.executeInTransaction(() -> this.ao.count(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ? AND (STATUS = 0 OR STATUS = 1)", new Object[]{templateId})));
        return count != 0;
    }

    public DataCleanerTaskEntity getCurrentInProgressTask() {
        return this.getFirstByQuery(DataCleanerTaskEntity.class, Query.select().where("STATUS = ?", new Object[]{TaskRequestStatusEnum.IN_PROGRESS.getCode()}));
    }

    public void setFoundObjectsCount(int taskId, int historyEntitiesCountByJobId) {
        this.ao.executeInTransaction(() -> {
            DataCleanerTaskEntity entity = (DataCleanerTaskEntity)this.ao.get(DataCleanerTaskEntity.class, (Object)taskId);
            entity.setFoundObjectsCount(historyEntitiesCountByJobId);
            entity.save();
            return true;
        });
    }

    public int getTasksCountForTemplate(int templateId) {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ? ", new Object[]{templateId})));
    }

    public List<DataCleanerTaskEntity> getAllTasksForRemoving(int templateId) {
        return (List)this.ao.executeInTransaction(() -> Lists.newArrayList(this.ao.find(DataCleanerTaskEntity.class, Query.select().where("TEMPLATE_ID = ?", new Object[]{templateId}).order("ID ASC"))));
    }
}

