/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerHistoryEntity;
import de.actonic.confluence.gdpr.util.Lists;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerHistoryDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerHistoryDao.class);

    @Autowired
    public DataCleanerHistoryDao(ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerHistoryEntity create(int jobId, String ceo, String space, String object, int ruleId, String data, int status, Timestamp creationDate) {
        return (DataCleanerHistoryEntity)this.ao.executeInTransaction(() -> {
            DataCleanerHistoryEntity entity = (DataCleanerHistoryEntity)this.ao.create(DataCleanerHistoryEntity.class, new DBParam[0]);
            entity.setTaskId(jobId);
            entity.setSpace(space);
            entity.setCeo(ceo);
            entity.setObject(object);
            entity.setRuleId(ruleId);
            entity.setData(data);
            entity.setStatus(status);
            entity.setCeoCreationDate(creationDate);
            entity.save();
            return entity;
        });
    }

    public DataCleanerHistoryEntity update(int entityId, String data, int status) {
        return (DataCleanerHistoryEntity)this.ao.executeInTransaction(() -> {
            DataCleanerHistoryEntity entity = (DataCleanerHistoryEntity)this.ao.get(DataCleanerHistoryEntity.class, (Object)entityId);
            entity.setTaskId(entityId);
            entity.setData(data);
            entity.setStatus(status);
            entity.save();
            return entity;
        });
    }

    public DataCleanerHistoryEntity get(int entityId) {
        DataCleanerHistoryEntity entity = (DataCleanerHistoryEntity)this.ao.executeInTransaction(() -> (DataCleanerHistoryEntity)this.ao.get(DataCleanerHistoryEntity.class, (Object)entityId));
        return entity;
    }

    public void delete(int id) {
        this.ao.executeInTransaction(() -> {
            DataCleanerHistoryEntity entity = this.getFirstByField(DataCleanerHistoryEntity.class, "ID", id);
            this.ao.delete(new RawEntity[]{entity});
            return true;
        });
    }

    public List<DataCleanerHistoryEntity> getHistoryEntitiesByJobId(int jobId) {
        return Lists.newArrayList((Object[])this.ao.executeInTransaction(() -> (DataCleanerHistoryEntity[])this.ao.find(DataCleanerHistoryEntity.class, Query.select().where("TASK_ID = ?", new Object[]{jobId}).order("ID ASC"))));
    }

    public int getHistoryEntitiesCountByJobId(int jobId) {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(DataCleanerHistoryEntity.class, Query.select().where("TASK_ID = ?", new Object[]{jobId})));
    }

    public List<DataCleanerHistoryEntity> getHistoryEntitiesByQuery(Query query) {
        return Lists.newArrayList((Object[])this.ao.executeInTransaction(() -> (DataCleanerHistoryEntity[])this.ao.find(DataCleanerHistoryEntity.class, query)));
    }

    public Map<String, String> getUniqProjectsByTasksId(int taskId) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        HashMap<String, String> resutls = new HashMap<String, String>();
        this.ao.stream(DataCleanerHistoryEntity.class, Query.select((String)"ID, SPACE").where("TASK_ID = ?", new Object[]{taskId}).distinct(), dataCleanerHistoryEntity -> {
            Map spaceMap = (Map)gson.fromJson(dataCleanerHistoryEntity.getSpace(), type);
            resutls.put((String)spaceMap.get("key"), (String)spaceMap.get("name"));
        });
        return resutls;
    }

    public void deleteAllEntitiesByTaskId(int taskId) {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(DataCleanerHistoryEntity.class, "TASK_ID = ?", new Object[]{taskId}));
    }
}

