/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentEntityChanger
extends BasicContentChanger {
    private static final Logger log = LoggerFactory.getLogger(ContentEntityChanger.class);
    protected PageManager pageManager;
    protected TransactionTemplate transactionTemplate;
    protected ContentEntityObjectDao entityObjectDao;
    protected ChangeIndexer changeIndexer;
    protected EntityManagerProvider entityManagerProvider;

    protected ContentEntityChanger(PluginSettingsFactory pluginSettingsFactory, PageManager pageManager, TransactionTemplate transactionTemplate, ContentEntityObjectDao entityObjectDao, ChangeIndexer changeIndexer, EntityManagerProvider entityManagerProvider) {
        super(pluginSettingsFactory, transactionTemplate);
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.entityObjectDao = entityObjectDao;
        this.changeIndexer = changeIndexer;
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        List<ContentEntityObject> versions = this.getVersionList((ContentEntityObject)pissue);
        for (ContentEntityObject ceo : versions) {
            if (!this.isAffectedCurrentVersion((EntityObject)ceo, user)) continue;
            return true;
        }
        return false;
    }

    private boolean isAffectedCurrentVersion(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            ContentEntityObject issue = this.pageManager.getById(pissue.getId());
            if (issue.getCreator() != null && issue.getCreator().equals(user)) {
                return true;
            }
            if (issue.getLastModifier() != null && issue.getLastModifier().equals(user)) {
                return true;
            }
            return this.isUserCollaborated((AbstractPage)issue, user, "collaborator") || this.isUserCollaborated((AbstractPage)issue, user, "touched");
        });
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating page creator...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        List<ContentEntityObject> versionIssues = this.getVersionList((ContentEntityObject)issue);
        int versionIssuesSize = versionIssues.size();
        for (ContentEntityObject version : versionIssues) {
            boolean transactionResult;
            if (!this.isAffectedCurrentVersion((EntityObject)version, sourceUser)) continue;
            long itemId = version.getId();
            changesTotal = changesTotal + itemId + ", ";
            this.setJobMessage(currentJobId, "Updating creator for version page " + itemId + "(" + versionIssues.indexOf(version) + " of " + versionIssuesSize + ")");
            try {
                transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                    AbstractPage object = (AbstractPage)this.pageManager.getById(version.getId());
                    try {
                        if (object.getCreator() != null && object.getCreator().equals(sourceUser)) {
                            object.setCreator(targetUser);
                        }
                        if (object.getLastModifier() != null && object.getLastModifier().equals(sourceUser)) {
                            object.setLastModifier(targetUser);
                        }
                        this.removeUserFromCreatorLastModifier(object, sourceUser, "collaborator");
                        this.removeUserFromCreatorLastModifier(object, sourceUser, "touched");
                        this.saveNewEntity((ContentEntityObject)object, (ContentEntityObject)issue);
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                });
            }
            catch (Exception e) {
                transactionResult = false;
            }
            if (transactionResult) {
                changesSuccess = changesSuccess + itemId + ", ";
                continue;
            }
            changesFail = changesFail + itemId + ", ";
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    protected List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ContentEntityObject tmpPage = versionPage;
        ArrayList<ContentEntityObject> versions = Lists.newArrayList(new ContentEntityObject[0]);
        versions.add(versionPage);
        while ((versionPage = this.pageManager.getPreviousVersion(versionPage)) != null) {
            versions.add(versionPage);
        }
        ContentEntityObject draft = this.entityObjectDao.findDraftFor(tmpPage.getId());
        if (draft != null) {
            versions.add(draft);
        }
        return versions;
    }

    private boolean isUserCollaborated(AbstractPage page, ConfluenceUser sourceUser, String type) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        boolean foundCollaborator = false;
        if (entityManager != null) {
            String user2ContentNamedQuery = "confluence.relation.user2content.get.simple";
            try {
                Query query = entityManager.createNamedQuery(user2ContentNamedQuery);
                query.setParameter("source", (Object)sourceUser);
                query.setParameter("target", (Object)page);
                query.setParameter("relationName", (Object)type);
                List collaboratorEntities = query.getResultList();
                if (collaboratorEntities.size() > 0) {
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        }
        return foundCollaborator;
    }

    protected boolean removeUserFromCreatorLastModifier(AbstractPage page, ConfluenceUser sourceUser, String type) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        boolean foundCollaborator = false;
        if (entityManager == null) {
            throw new NullPointerException("Could not anonymize page history. Hibernate session is NULL.");
        }
        String user2ContentNamedQuery = "confluence.relation.user2content.get.simple";
        try {
            Query query = entityManager.createNamedQuery(user2ContentNamedQuery);
            query.setParameter("source", (Object)sourceUser);
            query.setParameter("target", (Object)page);
            query.setParameter("relationName", (Object)type);
            List collaboratorEntities = query.getResultList();
            if (collaboratorEntities.size() == 1) {
                entityManager.remove(collaboratorEntities.get(0));
                foundCollaborator = true;
            } else if (collaboratorEntities.size() > 1) {
                throw new Exception(String.format("Found more than one collaborator entity for user {} and ceo {}. Will be skipped. Entities found: {}", sourceUser.getName(), page.getId(), collaboratorEntities.size()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return foundCollaborator;
    }

    protected void saveNewEntity(ContentEntityObject currentEntity, ContentEntityObject lastVersionEntity) {
        if (currentEntity.getVersion() != 1) {
            this.pageManager.saveContentEntity(currentEntity, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(false).suppressAutowatch(true).suppressNotifications(true)).build());
        } else {
            this.entityObjectDao.save((EntityObject)currentEntity);
        }
        this.changeIndexer.reIndexAllVersions((Searchable)lastVersionEntity);
    }
}

