/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.UserAnonymizerChangerManager;
import de.actonic.confluence.gdpr.component.service.PageService;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import de.actonic.confluence.gdpr.model.UserAnonymizerTaskModel;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerService {
    private static final Logger log = LoggerFactory.getLogger(UserAnonymizerService.class);
    private static final String USER_ANONYMIZATION_EVENT = "USER_ANONYMIZATION_EVENT";
    private static final String TASK_KEY = "task-key";
    @ComponentImport
    private final UserAccessor userAccessor;
    private final UserAnonymizerChangerManager userAnonymizerChangerManager;
    @ComponentImport
    private final CacheManager cacheManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final PluginSettings pluginSettings;
    private final PageService pageService;

    public UserAnonymizerService(UserAccessor userAccessor, UserAnonymizerChangerManager userAnonymizerChangerManager, CacheManager cacheManager, EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory, PageService pageService) {
        this.userAccessor = userAccessor;
        this.userAnonymizerChangerManager = userAnonymizerChangerManager;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.component.service.NewUserAnonymizerService");
        this.pageService = pageService;
    }

    public String runGlobalChanges(Map<String, String> configurationMap) {
        StringBuilder historyMessage = new StringBuilder();
        String userName = configurationMap.get("userName");
        ConfluenceUser sourceUser = this.userAccessor.getUserByName(userName);
        String target = configurationMap.get("target");
        ConfluenceUser targetUser = this.userAccessor.getUserByName(target);
        for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
            boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
            if (!this.userAnonymizerChangerManager.hasGlobalChanger(entry.getKey()) || !valueIsTrue) continue;
            GlobalContentChanger changer = this.userAnonymizerChangerManager.getGlobalChanger(entry.getKey());
            ContentChangerResult contentChangerResult = changer.changeIssues("actonic-gdpr-user-anonymizer-global-changes", sourceUser);
            historyMessage.append(contentChangerResult.getSuccessfullyChanged());
            if (!StringUtils.isNotBlank((CharSequence)contentChangerResult.getBadlyChanged())) continue;
            historyMessage.append(contentChangerResult.getBadlyChanged());
        }
        if (Boolean.parseBoolean(configurationMap.get("disable"))) {
            this.userAccessor.deactivateUser((User)sourceUser);
            historyMessage.append("User successfully disabled\n");
        }
        if (Boolean.parseBoolean(configurationMap.get("event"))) {
            Properties payload = new Properties();
            payload.setProperty("emitter", USER_ANONYMIZATION_EVENT);
            if (sourceUser != null) {
                payload.setProperty("sourceUsername", sourceUser.getName());
                payload.setProperty("sourceDisplayName", sourceUser.getFullName());
                payload.setProperty("sourceKey", sourceUser.getKey().getStringValue());
                payload.setProperty("sourceEmail", sourceUser.getEmail());
            }
            if (targetUser != null) {
                payload.setProperty("targetUsername", targetUser.getName());
                payload.setProperty("targetDisplayName", targetUser.getFullName());
                payload.setProperty("targetKey", targetUser.getKey().getStringValue());
                payload.setProperty("targetEmail", targetUser.getEmail());
            }
            this.eventPublisher.publish((Object)payload);
        }
        return historyMessage.toString();
    }

    public void execute(Map<String, String> configurationMap, ConfluenceUser user) {
        log.debug("Started JobRunner contentChanges");
        this.updateJobResults("in progress", "Preparing to content changes...", new HashMap<String, ContentChangerResult>(), Thread.currentThread().getName());
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        HashMap<String, ContentChangerResult> contentChangerResultMap = new HashMap<String, ContentChangerResult>();
        try {
            String sourceUserName = configurationMap.get("sourceUserName");
            ConfluenceUser sourceUser = this.userAccessor.getUserByName(sourceUserName);
            log.debug("> sourceUser found = " + (sourceUser != null));
            String targetUserName = configurationMap.get("targetUserName");
            ConfluenceUser targetUser = this.userAccessor.getUserByName(targetUserName);
            log.debug("> targetUser found = " + (targetUser != null));
            for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
                if (Thread.currentThread().isInterrupted()) break;
                boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
                if (!this.userAnonymizerChangerManager.hasCommonChanger(entry.getKey()) || !valueIsTrue) continue;
                BasicContentChanger changer = this.userAnonymizerChangerManager.getCommonChanger(entry.getKey());
                ContentChangerResult contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent(null, sourceUser)) : changer.changeIssues(TASK_KEY, null, sourceUser, targetUser);
                this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
            }
            List<AbstractPage> pages = this.pageService.getPages(configurationMap.get("cql"));
            int pageCounter = 0;
            for (AbstractPage page : pages) {
                for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
                    ContentChangerResult contentChangerResult;
                    BasicContentChanger changer;
                    if (Thread.currentThread().isInterrupted()) break;
                    boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
                    if (this.userAnonymizerChangerManager.hasPageChanger(entry.getKey()) && valueIsTrue) {
                        changer = this.userAnonymizerChangerManager.getPageChanger(entry.getKey());
                        contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent((EntityObject)page, sourceUser)) : changer.changeIssues(TASK_KEY, (EntityObject)page, sourceUser, targetUser);
                        this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
                    }
                    if (!this.userAnonymizerChangerManager.hasSpaceChanger(entry.getKey()) || !valueIsTrue) continue;
                    changer = this.userAnonymizerChangerManager.getSpaceChanger(entry.getKey());
                    contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent((EntityObject)page.getSpace(), sourceUser)) : changer.changeIssues(TASK_KEY, (EntityObject)page.getSpace(), sourceUser, targetUser);
                    this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
                }
                if (Thread.currentThread().isInterrupted()) break;
                this.updateJobResults("in progress", "Task in progress. Proceed pages " + ++pageCounter + " from " + pages.size(), contentChangerResultMap, Thread.currentThread().getName());
            }
            try {
                ManagedCache cpCache;
                ManagedCache cpsCache = this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermissionSet");
                if (cpsCache != null) {
                    cpsCache.clear();
                }
                if ((cpCache = this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermission")) != null) {
                    cpCache.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Thread.currentThread().isInterrupted()) {
                this.updateJobResults("done", "execution was stopped", new HashMap<String, ContentChangerResult>(), "");
            } else {
                this.updateJobResults("done", "finished", contentChangerResultMap, Thread.currentThread().getName());
            }
            log.debug("Finished JobRunner contentChanges");
        }
        catch (Exception e) {
            this.updateJobResults("failed", "Failed!", new HashMap<String, ContentChangerResult>(), Thread.currentThread().getName());
            log.error("Failed JobRunner contentChanges", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void putContentChangerResultValue(Map<String, ContentChangerResult> contentChangerResultMap, ContentChangerResult value) {
        String changerName = value.getChangerName();
        if (contentChangerResultMap.containsKey(changerName)) {
            ContentChangerResult tempValue = contentChangerResultMap.get(changerName);
            if (!tempValue.getAffectedContent().contains(value.getAffectedContent())) {
                tempValue.setAffectedContent(tempValue.getAffectedContent() + value.getAffectedContent());
            }
            if (!tempValue.getBadlyChanged().contains(value.getBadlyChanged())) {
                tempValue.setBadlyChanged(tempValue.getBadlyChanged() + value.getBadlyChanged());
            }
            if (!tempValue.getSuccessfullyChanged().contains(value.getSuccessfullyChanged())) {
                tempValue.setSuccessfullyChanged(tempValue.getSuccessfullyChanged() + value.getSuccessfullyChanged());
            }
            contentChangerResultMap.put(changerName, tempValue);
        } else {
            contentChangerResultMap.put(changerName, value);
        }
    }

    public String stopCurrentJob() {
        boolean isStopped;
        UserAnonymizerTaskModel userAnonymizerTaskModel = (UserAnonymizerTaskModel)GDPRJsonUtils.fromJson((String)((String)this.pluginSettings.get(TASK_KEY)), UserAnonymizerTaskModel.class);
        if (userAnonymizerTaskModel != null) {
            String threadName = userAnonymizerTaskModel.getThreadName();
            Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
            for (Thread thread : allThreads.keySet()) {
                if (!thread.getName().equals(threadName)) continue;
                this.updateJobResults("done", "execution was stopped", new HashMap<String, ContentChangerResult>(), "");
                thread.interrupt();
                String message = "Job was stopped for thread " + threadName;
                log.debug(message);
                return message;
            }
        }
        if (isStopped = this.tryStopUserAnonymizerServiceThread()) {
            this.updateJobResults("done", "execution was stopped", new HashMap<String, ContentChangerResult>(), "");
            String message = "User anonymizer thread was stopped ";
            log.debug(message);
            return message;
        }
        String message = "Couldn't stop the task";
        log.debug(message);
        return message;
    }

    public boolean tryStopUserAnonymizerServiceThread() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        for (Thread thread : allThreads.keySet()) {
            boolean isPresent;
            if (!thread.getName().contains("Caesium") || !(isPresent = Arrays.stream(thread.getStackTrace()).anyMatch(t -> "UserAnonymizerService.java".equals(t.getFileName()) && "execute".equals(t.getMethodName())))) continue;
            log.debug("UserAnonymizerServiceThread is present");
            this.updateJobResults("done", "execution was stopped", new HashMap<String, ContentChangerResult>(), "");
            thread.interrupt();
            return true;
        }
        return false;
    }

    public String getTaskResult() {
        Object jobStatusObj = this.pluginSettings.get(TASK_KEY);
        return (String)jobStatusObj;
    }

    public void removeTaskResult() {
        this.pluginSettings.remove(TASK_KEY);
    }

    public void updateJobResults(String status, String message, Map<String, ContentChangerResult> map, String threadName) {
        UserAnonymizerTaskModel userAnonymizerTaskModel = (UserAnonymizerTaskModel)GDPRJsonUtils.fromJson((String)((String)this.pluginSettings.get(TASK_KEY)), UserAnonymizerTaskModel.class);
        if (userAnonymizerTaskModel == null) {
            userAnonymizerTaskModel = new UserAnonymizerTaskModel(status, message, new ArrayList<ContentChangerResult>(map.values()), threadName);
            this.pluginSettings.put(TASK_KEY, (Object)new Gson().toJson((Object)userAnonymizerTaskModel));
        } else {
            if (status != null && !status.isEmpty()) {
                userAnonymizerTaskModel.setStatus(status);
            }
            if (message != null && !message.isEmpty()) {
                userAnonymizerTaskModel.setMessage(message);
            }
            if (map != null && !map.isEmpty()) {
                userAnonymizerTaskModel.setResults(new ArrayList<ContentChangerResult>(map.values()));
            }
            if (threadName != null && !threadName.isEmpty()) {
                userAnonymizerTaskModel.setThreadName(threadName);
            }
            this.pluginSettings.put(TASK_KEY, (Object)new Gson().toJson((Object)userAnonymizerTaskModel));
        }
    }
}

