/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.ao.RequestDataEntity;
import de.actonic.confluence.gdpr.ao.RequestDataHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.RequestDataHistoryDao;
import de.actonic.confluence.gdpr.component.manager.RequestDataSearchManager;
import de.actonic.confluence.gdpr.component.manager.RequestMyDataDao;
import de.actonic.confluence.gdpr.model.RequestDataHistoryModel;
import de.actonic.confluence.gdpr.model.RequestDataModel;
import de.actonic.confluence.gdpr.model.RequestDataShowedModel;
import de.actonic.confluence.gdpr.model.RequestDataStatus;
import de.actonic.confluence.gdpr.model.RequestProcessStatus;
import de.actonic.confluence.gdpr.model.RequestRelationTypeEnum;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestMyDataService {
    private static final Logger log = LoggerFactory.getLogger(RequestMyDataService.class);
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private RequestMyDataDao requestMyDataDao;
    private RequestDataHistoryDao requestDataHistoryDao;
    private RequestDataSearchManager requestDataSearchManager;
    @ComponentImport
    private UserAccessor userAccessor;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private PageManager pageManager;
    private final IGDPRUserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public RequestMyDataService(RequestMyDataDao requestMyDataDao, RequestDataHistoryDao requestDataHistoryDao, RequestDataSearchManager requestDataSearchManager, UserAccessor userAccessor, SpaceManager spaceManager, PageManager pageManager, IGDPRUserManager userManager, I18nResolver i18n) {
        this.requestMyDataDao = requestMyDataDao;
        this.requestDataHistoryDao = requestDataHistoryDao;
        this.requestDataSearchManager = requestDataSearchManager;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    public void createRequest(String userName) throws Exception {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (this.requestMyDataDao.isRequestAlreadyExists(user.getKey().getStringValue())) {
            throw new Exception("Request already exists");
        }
        this.requestMyDataDao.create(user.getKey().getStringValue());
    }

    private RequestDataModel entityToModel(RequestDataEntity entity) {
        if (entity == null) {
            return null;
        }
        RequestDataModel model = RequestDataModel.builder().id(entity.getID()).userkey(entity.getUserKey()).createDate(entity.getCreateDate()).startDate(entity.getStartDate()).endDate(entity.getEndDate()).status(entity.getStatus()).cancel(entity.isCancel()).error(entity.isError()).ends(entity.isEnds()).extraFields(entity.getExtraFields()).build();
        return model;
    }

    public List<RequestDataModel> getHistoryRequests() {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        List<RequestDataEntity> entities = this.requestMyDataDao.getHistory();
        List<RequestDataModel> models = entities.stream().map(e -> this.entityToModel((RequestDataEntity)e)).collect(Collectors.toList());
        return models;
    }

    public List<RequestDataModel> getQueueRequests() {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        List<RequestDataEntity> entities = this.requestMyDataDao.getQueue();
        List<RequestDataModel> models = entities.stream().map(e -> this.entityToModel((RequestDataEntity)e)).collect(Collectors.toList());
        return models;
    }

    public RequestDataModel getUserRequest(String userName) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            return null;
        }
        RequestDataEntity entity = this.requestMyDataDao.get(user.getKey().getStringValue());
        if (entity != null) {
            return this.entityToModel(entity);
        }
        return null;
    }

    public RequestDataModel getLastFinishedUserRequest(String userName) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            return null;
        }
        RequestDataEntity entity = this.requestMyDataDao.getLastFinished(user.getKey().getStringValue());
        if (entity != null) {
            return this.entityToModel(entity);
        }
        return null;
    }

    public RequestDataModel getCurrentRequest() {
        RequestDataEntity entity = this.requestMyDataDao.getCurrent();
        if (entity != null) {
            return this.entityToModel(entity);
        }
        return null;
    }

    public void cancelRequest(Integer requestId) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.requestMyDataDao.cancel(requestId);
    }

    private boolean ifCancelExists(Integer taskId) {
        RequestDataModel request = this.entityToModel(this.requestMyDataDao.get(taskId));
        return request.getCancel();
    }

    private boolean executeRequest(Integer taskId) {
        Integer entity;
        Object object;
        Object model;
        RequestDataModel request = this.entityToModel(this.requestMyDataDao.get(taskId));
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(request.getUserkey()));
        this.requestMyDataDao.start(taskId);
        Integer spaceProgressCount = 0;
        Integer foundElements = 0;
        log.debug("start - notifications");
        Optional<HashMap<String, List<Long>>> notificationOpt = this.requestDataSearchManager.getNotificationsForUser(user);
        if (notificationOpt.isPresent()) {
            Integer n;
            HashMap<String, List<Long>> notificationMap = notificationOpt.get();
            if (notificationMap.containsKey("space")) {
                for (Long spaceId : notificationMap.get("space")) {
                    if (this.ifCancelExists(taskId)) {
                        return false;
                    }
                    Space space = this.spaceManager.getSpace(spaceId.longValue());
                    model = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.WATCHER_SPACE.getCode()).currentObject(space.getKey()).spaceKey(space.getKey()).extra(this.getExtraData("spaceName", space.getName())).build();
                    this.requestDataHistoryDao.add((RequestDataHistoryModel)model);
                    n = foundElements;
                    foundElements = foundElements + 1;
                    object = foundElements;
                }
            }
            if (notificationMap.containsKey("page")) {
                for (Long pageId : notificationMap.get("page")) {
                    if (this.ifCancelExists(taskId)) {
                        return false;
                    }
                    entity = this.pageManager.getAbstractPage(pageId.longValue());
                    model = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.WATCHER_PAGE.getCode()).currentObject(entity.getIdAsString()).currentTitle(entity.getTitle()).spaceKey(((AbstractPage)entity).getSpaceKey()).extra(this.getExtraData("spaceName", ((AbstractPage)entity).getSpace().getName())).build();
                    this.requestDataHistoryDao.add((RequestDataHistoryModel)model);
                    n = foundElements;
                    foundElements = foundElements + 1;
                    object = foundElements;
                }
            }
        }
        log.debug("end - notifications");
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            if (this.ifCancelExists(taskId)) {
                return false;
            }
            entity = spaceProgressCount;
            spaceProgressCount = spaceProgressCount + 1;
            model = spaceProgressCount;
            Integer pageProgressCount = 0;
            Optional<Boolean> spaceCreatorOpt = this.requestDataSearchManager.equalsCreatorOrLastModifier(space, user);
            if (spaceCreatorOpt.isPresent()) {
                RequestDataHistoryModel model2 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.CREATOR_SPACE.getCode()).currentObject(space.getKey()).spaceKey(space.getKey()).extra(this.getExtraData("spaceName", space.getName())).build();
                this.requestDataHistoryDao.add(model2);
                object = foundElements;
                Integer n = foundElements = Integer.valueOf(foundElements + 1);
            }
            ArrayList<AbstractPage> pages = Lists.newArrayList(new AbstractPage[0]);
            pages.addAll(this.pageManager.getPages(space, true));
            pages.addAll(this.pageManager.getBlogPosts(space, true));
            for (AbstractPage page : pages) {
                Integer n;
                Integer n2;
                RequestDataHistoryModel model3;
                Integer n3;
                if (this.ifCancelExists(taskId)) {
                    return false;
                }
                log.debug("===================================");
                log.debug("page - [" + page.getSpaceKey() + "] " + page.getTitle());
                Integer n4 = pageProgressCount;
                Integer n5 = pageProgressCount = Integer.valueOf(pageProgressCount + 1);
                RequestProcessStatus status = RequestProcessStatus.builder().spaceCount(spaces.size()).pageCount(pages.size()).currentSpaceNum(spaceProgressCount).currentPageNum(pageProgressCount).currentSpaceKey(space.getKey()).currentPageTitle(page.getTitle()).foundElements(foundElements).build();
                this.requestMyDataDao.update(taskId, RequestDataStatus.WORK.getText(), status.toString());
                log.debug("start - page creator");
                Optional<Boolean> equalsForEntity = this.requestDataSearchManager.equalsCreatorOrLastModifierWithAllVersions((ContentEntityObject)page, user);
                if (equalsForEntity.isPresent()) {
                    RequestDataHistoryModel model4 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.CREATOR_PAGE.getCode()).currentObject(page.getIdAsString()).currentTitle(page.getTitle()).spaceKey(page.getSpaceKey()).extra(this.getExtraData("spaceName", space.getName())).build();
                    this.requestDataHistoryDao.add(model4);
                    Iterator iterator = foundElements;
                    n3 = foundElements = Integer.valueOf(foundElements + 1);
                }
                log.debug("end - page creator");
                log.debug("start - page mention");
                Optional<Boolean> mentionForPage = this.requestDataSearchManager.findUserMentions(page.getId(), user);
                if (mentionForPage.isPresent()) {
                    RequestDataHistoryModel model5 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.MENTION_PAGE.getCode()).currentObject(page.getIdAsString()).currentTitle(page.getTitle()).spaceKey(page.getSpaceKey()).extra(this.getExtraData("spaceName", space.getName())).build();
                    this.requestDataHistoryDao.add(model5);
                    n3 = foundElements;
                    Integer n6 = foundElements = Integer.valueOf(foundElements + 1);
                }
                log.debug("end - page mention");
                log.debug("start - find comments data");
                for (Comment comment : page.getComments()) {
                    log.debug("start - comment creator");
                    Optional<Boolean> equalsForComment = this.requestDataSearchManager.equalsCreatorOrLastModifier((ContentEntityObject)comment, user);
                    if (equalsForComment.isPresent()) {
                        model3 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.CREATOR_COMMENT.getCode()).currentObject(comment.getIdAsString()).currentTitle(comment.getDisplayTitle()).parentObject(page.getIdAsString()).parentTitle(page.getTitle()).spaceKey(page.getSpaceKey()).extra(this.getExtraData("pageId", page.getIdAsString(), "spaceName", space.getName())).build();
                        this.requestDataHistoryDao.add(model3);
                        n2 = foundElements;
                        n = foundElements = Integer.valueOf(foundElements + 1);
                    }
                    log.debug("start - end creator");
                    log.debug("start - comment mention");
                    Optional<Boolean> mentionForComment = this.requestDataSearchManager.findUserMentions(comment.getId(), user);
                    if (mentionForComment.isPresent()) {
                        RequestDataHistoryModel model6 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.MENTION_COMMENT.getCode()).currentObject(comment.getIdAsString()).currentTitle(comment.getDisplayTitle()).parentObject(page.getIdAsString()).parentTitle(page.getTitle()).spaceKey(page.getSpaceKey()).extra(this.getExtraData("pageId", page.getIdAsString(), "spaceName", space.getName())).build();
                        this.requestDataHistoryDao.add(model6);
                        n = foundElements;
                        Integer n7 = foundElements = Integer.valueOf(foundElements + 1);
                    }
                    log.debug("end - comment mention");
                }
                log.debug("end - find comments data");
                log.debug("start - attachment creator");
                for (Attachment attachment : page.getAttachments()) {
                    Optional<Boolean> equalsForAttachment = this.requestDataSearchManager.equalsCreatorOrLastModifier((ContentEntityObject)attachment, user);
                    if (!equalsForAttachment.isPresent()) continue;
                    model3 = RequestDataHistoryModel.builder().taskId(taskId).relationType(RequestRelationTypeEnum.CREATOR_ATTACH.getCode()).currentObject(attachment.getIdAsString()).currentTitle(attachment.getFileName()).parentObject(page.getIdAsString()).parentTitle(page.getTitle()).spaceKey(page.getSpaceKey()).extra(this.getExtraData("spaceName", space.getName())).build();
                    this.requestDataHistoryDao.add(model3);
                    n2 = foundElements;
                    n = foundElements = Integer.valueOf(foundElements + 1);
                }
                log.debug("end - attachment creator");
            }
        }
        this.requestMyDataDao.finish(taskId);
        return true;
    }

    public JobRunnerResponse execute() {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        RequestDataModel request = this.entityToModel(this.requestMyDataDao.getNext());
        if (request != null) {
            try {
                Integer taskId = request.getId();
                if (this.executeRequest(taskId)) {
                    log.debug("Request successfully done: " + request.getId());
                } else {
                    request = this.entityToModel(this.requestMyDataDao.get(taskId));
                    if (request.getCancel().booleanValue()) {
                        log.error("Request [" + taskId + "] cancelled");
                        return JobRunnerResponse.aborted((String)("Request [" + taskId + "] cancelled"));
                    }
                    if (request.getError().booleanValue()) {
                        log.error("Request [" + taskId + "] does not finished, because error \"" + request.getExtraFields() + "\"");
                        return JobRunnerResponse.aborted((String)("Request [" + taskId + "] does not finished, because error \"" + request.getExtraFields() + "\""));
                    }
                }
                return JobRunnerResponse.success((String)("Request " + taskId + " done"));
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "No message for this error...";
                this.requestMyDataDao.error(request.getId(), errorMessage);
                return JobRunnerResponse.failed((String)errorMessage);
            }
        }
        return JobRunnerResponse.success((String)"No requests");
    }

    public RequestDataShowedModel convertToShowedModel(RequestDataModel model) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        if (model == null) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(model.getUserkey()));
        String userName = user != null ? user.getFullName() : model.getUserkey();
        String login = user != null ? user.getName() : model.getUserkey();
        RequestDataShowedModel convertedModel = RequestDataShowedModel.builder().id(model.getId()).ends(model.getEnds()).cancel(model.getCancel()).error(model.getError()).status(model.getStatus()).extraFields(model.getExtraFields()).userName(userName).login(login).createDate(model.getCreateDate() != null ? SIMPLE_DATE_FORMAT.format(new Date(model.getCreateDate())) : "").startDate(model.getStartDate() != null ? SIMPLE_DATE_FORMAT.format(new Date(model.getStartDate())) : "").endDate(model.getEndDate() != null ? SIMPLE_DATE_FORMAT.format(new Date(model.getEndDate())) : "").build();
        return convertedModel;
    }

    public RequestDataHistoryModel convertToShowedModel(RequestDataHistoryEntity entity) {
        if (entity == null) {
            return null;
        }
        RequestDataHistoryModel model = RequestDataHistoryModel.builder().taskId(entity.getTaskId()).relationType(entity.getRelationType()).currentObject(entity.getCurrentObject()).currentTitle(entity.getCurrentTitle()).parentObject(entity.getParentObject()).parentTitle(entity.getParentTitle()).spaceKey(entity.getSpaceKey()).extra((HashMap)new Gson().fromJson(entity.getExtra(), HashMap.class)).build();
        return model;
    }

    public List<RequestDataHistoryModel> getRequestResults(String userName, Integer rowsPerPage, Integer relationType, String orderBy, Integer page) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userName})) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        String userKey = user != null ? user.getKey().getStringValue() : userName;
        RequestDataEntity entity = this.requestMyDataDao.getLastFinished(userKey);
        if (entity == null) {
            return null;
        }
        List<RequestDataHistoryEntity> results = this.requestDataHistoryDao.getFilteredHistory(entity.getID(), rowsPerPage, relationType, orderBy, page);
        ArrayList<RequestDataHistoryModel> models = Lists.newArrayList(new RequestDataHistoryModel[0]);
        results.forEach(e -> models.add(this.convertToShowedModel((RequestDataHistoryEntity)e)));
        return models;
    }

    public Integer getNumberOfPages(String userName, Integer rowsPerPage, Integer relationType) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        String userKey = user != null ? user.getKey().getStringValue() : userName;
        RequestDataEntity entity = this.requestMyDataDao.getLastFinished(userKey);
        if (entity == null) {
            return null;
        }
        Integer size = this.requestDataHistoryDao.getHistoryCount(entity.getID(), relationType);
        return (int)Math.ceil((double)size.intValue() / (double)rowsPerPage.intValue());
    }

    public Integer getRelationResult(String userName, Integer relationType) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        String userKey = user != null ? user.getKey().getStringValue() : userName;
        RequestDataEntity entity = this.requestMyDataDao.getLastFinished(userKey);
        if (entity == null) {
            return null;
        }
        return this.requestDataHistoryDao.getHistoryCount(entity.getID(), relationType);
    }

    private HashMap<String, String> getExtraData(String key, String value) {
        HashMap<String, String> extraData = new HashMap<String, String>();
        extraData.put(key, value);
        return extraData;
    }

    private HashMap<String, String> getExtraData(String key1, String value1, String key2, String value2) {
        HashMap<String, String> extraData = new HashMap<String, String>();
        extraData.put(key1, value1);
        extraData.put(key2, value2);
        return extraData;
    }
}

