/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PageService {
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    private final CQLSearchService cqlSearchService;
    private final ContentEntityManager contentEntityManager;

    public PageService(SpaceManager spaceManager, PageManager pageManager, @ComponentImport CQLSearchService cqlSearchService, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.cqlSearchService = cqlSearchService;
        this.contentEntityManager = contentEntityManager;
    }

    public List<AbstractPage> getPages(String cql) {
        ArrayList<AbstractPage> result = new ArrayList<AbstractPage>();
        if (StringUtils.isBlank((CharSequence)cql)) {
            List spaces = this.spaceManager.getAllSpaces();
            spaces.forEach(space -> {
                result.addAll(this.pageManager.getPages(space, true));
                result.addAll(this.pageManager.getBlogPosts(space, true));
            });
        } else {
            result.addAll(this.getPagesByCql(cql));
        }
        return result;
    }

    private List<AbstractPage> getPagesByCql(String cql) {
        int limit = 100;
        ArrayList<AbstractPage> results = Lists.newArrayList(new AbstractPage[0]);
        try {
            int currentCount = 0;
            List<AbstractPage> temp = this.getPagesByCqlByLimit(cql, currentCount, limit);
            while (temp != null && temp.size() > 0) {
                results.addAll(temp);
                temp = this.getPagesByCqlByLimit(cql, currentCount += temp.size(), limit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private List<AbstractPage> getPagesByCqlByLimit(String cql, int start, int size) {
        cql = this.modifySqlRequest(cql);
        try {
            SimplePageRequest pageRequest = new SimplePageRequest(start, size);
            PageResponse contents = this.cqlSearchService.searchContent(cql, SearchContext.EMPTY, (PageRequest)pageRequest, new Expansion[0]);
            List results = contents.getResults();
            if (results != null && results.size() > 0) {
                return this.convertContentToAbstractPage(results);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String modifySqlRequest(String cql) {
        cql = StringUtils.isBlank((CharSequence)cql) ? "type IN (blogpost, page)" : cql + " AND type IN (blogpost, page)";
        return cql;
    }

    private List<AbstractPage> convertContentToAbstractPage(List<Content> results) {
        ArrayList<AbstractPage> contentEntityObjects = Lists.newArrayList(new AbstractPage[0]);
        for (Content result : results) {
            ContentEntityObject ceo = this.contentEntityManager.getById(result.getId().asLong());
            if (!(ceo instanceof Page) && !(ceo instanceof BlogPost)) continue;
            contentEntityObjects.add((AbstractPage)ceo);
        }
        return contentEntityObjects;
    }
}

