/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultDeleteContext;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.ao.DataRuleEntity;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.confluence.gdpr.component.manager.CronManager;
import de.actonic.confluence.gdpr.component.manager.DataRuleDao;
import de.actonic.confluence.gdpr.component.manager.EmailManager;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.confluence.gdpr.component.service.DataRuleHistoryService;
import de.actonic.confluence.gdpr.model.ActionNotificationUserType;
import de.actonic.confluence.gdpr.model.ActionType;
import de.actonic.confluence.gdpr.model.DataRuleActionExecutionResultModel;
import de.actonic.confluence.gdpr.model.DataRuleHistoryModel;
import de.actonic.confluence.gdpr.model.DataRuleModel;
import de.actonic.confluence.gdpr.model.NotificationType;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.confluence.gdpr.util.Maps;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRNotFoundException;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleService {
    private static final Logger log = LoggerFactory.getLogger(DataRuleService.class);
    private final DataRuleDao dataRuleDao;
    private final CronManager cronManager;
    private final CqlManager cqlManager;
    private final GDPRSettingsManager GDPRSettingsManager;
    private final DataRuleHistoryService dataRuleHistoryService;
    private final EmailManager emailManager;
    private final UserNameConvertManager userNameConvertManager;
    private final PluginSettings pluginSettings;
    @ComponentImport
    private final UserAccessor userManager;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final CommentManager commentManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final TrashManager trashManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private final NotificationManager notificationManager;
    private final IGDPRUserManager gdprUserManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public DataRuleService(DataRuleDao dataRuleDao, CronManager cronManager, PluginSettingsFactory pluginSettingsFactory, CqlManager cqlManager, GDPRSettingsManager GDPRSettingsManager2, DataRuleHistoryService dataRuleHistoryService, EmailManager emailManager, UserNameConvertManager userNameConvertManager, UserAccessor userManager, ApplicationProperties applicationProperties, CommentManager commentManager, PageManager pageManager, TrashManager trashManager, SpaceManager spaceManager, ContentPermissionManager contentPermissionManager, NotificationManager notificationManager, IGDPRUserManager gdprUserManager, I18nResolver i18n) {
        this.dataRuleDao = dataRuleDao;
        this.cronManager = cronManager;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.dla.last-run");
        this.cqlManager = cqlManager;
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.dataRuleHistoryService = dataRuleHistoryService;
        this.emailManager = emailManager;
        this.userNameConvertManager = userNameConvertManager;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.commentManager = commentManager;
        this.pageManager = pageManager;
        this.trashManager = trashManager;
        this.spaceManager = spaceManager;
        this.contentPermissionManager = contentPermissionManager;
        this.notificationManager = notificationManager;
        this.gdprUserManager = gdprUserManager;
        this.i18n = i18n;
    }

    public DataRuleModel entityToModel(DataRuleEntity dataRuleEntity) {
        DataRuleModel dataRuleModel = DataRuleModel.builder().id(dataRuleEntity.getID()).enabled(dataRuleEntity.getIsActive()).isActive(dataRuleEntity.getIsActive()).name(dataRuleEntity.getName()).cql(dataRuleEntity.getCql()).cron(dataRuleEntity.getCron()).creator(this.userNameConvertManager.convertUserKeyToUserName(dataRuleEntity.getCreator())).creationDate(dataRuleEntity.getCreationDate()).lastModifier(this.userNameConvertManager.convertUserKeyToUserName(dataRuleEntity.getLastModifier())).modificationDate(dataRuleEntity.getModificationDate()).type(dataRuleEntity.getType()).parameters(dataRuleEntity.getParameters()).notificationType(dataRuleEntity.getNotificationType()).notificationParameters(this.jsonStringToMap(dataRuleEntity.getNotificationParameters())).build();
        return dataRuleModel;
    }

    private Map<String, String> jsonStringToMap(String jsonString) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map stringMap = (Map)gson.fromJson(jsonString, type);
        return stringMap;
    }

    public List<DataRuleModel> getItems() {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        ArrayList<DataRuleModel> dataRuleModels = Lists.newArrayList(new DataRuleModel[0]);
        List<DataRuleEntity> dataRuleEntities = this.dataRuleDao.getAllEntities();
        dataRuleEntities.forEach(dataRuleEntity -> {
            DataRuleModel dataRuleModel = this.entityToModel((DataRuleEntity)dataRuleEntity);
            Object lastRunDateObj = this.pluginSettings.get(String.valueOf(dataRuleEntity.getID()));
            if (lastRunDateObj != null && Long.valueOf(lastRunDateObj.toString()) != 0L) {
                dataRuleModel.setExtraOptions(Maps.getMapData("lastRun", lastRunDateObj.toString()));
            }
            dataRuleModels.add(dataRuleModel);
        });
        return dataRuleModels;
    }

    public DataRuleModel getItem(int id) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        DataRuleEntity entity = this.dataRuleDao.getById(id);
        if (entity == null) {
            throw new GDPRNotFoundException("DataRuleEntity with id: " + id + "not found");
        }
        return this.entityToModel(entity);
    }

    public void deleteItem(int id) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.dataRuleDao.deleteEntity(id);
    }

    public DataRuleModel cloneItem(int id, ConfluenceUser applicationUser) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        DataRuleEntity entity = this.dataRuleDao.getById(id);
        if (entity == null) {
            return null;
        }
        return this.createItem(applicationUser, entity.getIsActive(), entity.getName(), entity.getCron(), entity.getCql(), entity.getType(), entity.getParameters(), entity.getNotificationType(), entity.getNotificationParameters());
    }

    public DataRuleModel createItem(ConfluenceUser applicationUser, Boolean enabled, String name, String cron, String cql, String type, String parameters, String notificationType, String notificationParameters) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        DataRuleEntity entity = this.dataRuleDao.createEntity(enabled, name, applicationUser.getKey().getStringValue(), cron, cql, type, parameters, notificationType, notificationParameters);
        return this.entityToModel(entity);
    }

    public DataRuleModel updateItem(int id, ConfluenceUser applicationUser, Boolean enabled, String name, String cron, String cql, String type, String parameters, String notificationType, String notificationParameters) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        DataRuleEntity entity = this.dataRuleDao.updateEntity(id, enabled, name, applicationUser.getKey().getStringValue(), cron, cql, type, parameters, notificationType, notificationParameters);
        if (entity == null) {
            throw new GDPRNotFoundException("DataRuleEntity with id: " + id + "not found");
        }
        return this.entityToModel(entity);
    }

    public DataRuleModel toggleItem(int id, ConfluenceUser applicationUser) {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        DataRuleEntity dataRuleEntity = this.dataRuleDao.getById(id);
        if (dataRuleEntity == null) {
            throw new GDPRNotFoundException("DataRuleEntity with id: " + id + "not found");
        }
        DataRuleModel dataRuleModel = dataRuleEntity.getIsActive() ? this.entityToModel(this.dataRuleDao.disableRule(id, applicationUser)) : this.entityToModel(this.dataRuleDao.enableRule(id, applicationUser));
        Object lastRunDateObj = this.pluginSettings.get(String.valueOf(dataRuleEntity.getID()));
        if (lastRunDateObj != null && Long.valueOf(lastRunDateObj.toString()) != 0L) {
            dataRuleModel.setExtraOptions(Maps.getMapData("lastRun", lastRunDateObj.toString()));
        }
        return dataRuleModel;
    }

    public void performDataRulesActions() {
        List<DataRuleEntity> dataRuleEntities = this.dataRuleDao.getActiveEntities();
        for (DataRuleEntity dataRuleEntity : dataRuleEntities) {
            boolean isCronValid;
            Object lastRunDateObj = this.pluginSettings.get(String.valueOf(dataRuleEntity.getID()));
            if (lastRunDateObj == null) {
                this.pluginSettings.put(String.valueOf(dataRuleEntity.getID()), (Object)String.valueOf(new Date().getTime()));
                continue;
            }
            long realLastRunDate = Long.valueOf(lastRunDateObj.toString());
            String cron = dataRuleEntity.getCron();
            boolean bl = isCronValid = this.cronManager.isCronValid(cron) && this.cronManager.isCronDurationValid(cron);
            if (isCronValid) {
                long lastExecutionFromCron = this.cronManager.getLastExecutionInMillis(cron);
                if (lastExecutionFromCron <= realLastRunDate) continue;
                try {
                    this.runDataRule(dataRuleEntity.getID());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    e.printStackTrace();
                }
                continue;
            }
            this.dataRuleHistoryService.createEntity(dataRuleEntity.getID(), "Cannot execute the rule because CRON expression is not valid! This rule will be disabled!", "", 2);
            this.dataRuleDao.disableRule(dataRuleEntity.getID());
        }
    }

    private List<String> getEmailsForPage(List<AbstractPage> pages, ActionNotificationUserType type) {
        ArrayList<String> result = Lists.newArrayList(new String[0]);
        HashMap spaceKeyWithEmails = new HashMap();
        switch (type) {
            case CREATOR: {
                for (AbstractPage page : pages) {
                    if (page.getCreator() == null || !StringUtils.isNotBlank((CharSequence)page.getCreator().getEmail())) continue;
                    result.add(page.getCreator().getEmail());
                }
                break;
            }
            case LAST_MODIFIER: {
                for (AbstractPage page : pages) {
                    if (page.getLastModifier() == null || !StringUtils.isNotBlank((CharSequence)page.getLastModifier().getEmail())) continue;
                    result.add(page.getLastModifier().getEmail());
                }
                break;
            }
            case SPACE_LEAD: {
                for (AbstractPage page : pages) {
                    if (page.getSpace() == null) continue;
                    if (spaceKeyWithEmails.containsKey(page.getSpaceKey())) {
                        result.addAll((Collection)spaceKeyWithEmails.get(page.getSpaceKey()));
                        continue;
                    }
                    ArrayList emails = new ArrayList();
                    this.spaceManager.getSpaceAdmins(page.getSpace()).stream().forEach(user -> {
                        if (user != null && StringUtils.isNotBlank((CharSequence)user.getEmail())) {
                            emails.add(user.getEmail());
                        }
                    });
                    spaceKeyWithEmails.put(page.getSpaceKey(), emails);
                    result.addAll(emails);
                }
                break;
            }
            case WATCHERS: {
                for (AbstractPage page : pages) {
                    List notifications = this.notificationManager.getNotificationsByContent((ContentEntityObject)page);
                    for (Notification notification : notifications) {
                        if (notification.getReceiver() == null || !StringUtils.isNotBlank((CharSequence)notification.getReceiver().getEmail())) continue;
                        result.add(notification.getReceiver().getEmail());
                    }
                }
                break;
            }
        }
        return result;
    }

    private List<String> getEmailsForPage(AbstractPage page, ActionNotificationUserType type) {
        ArrayList<String> result = Lists.newArrayList(new String[0]);
        switch (type) {
            case CREATOR: {
                if (page.getCreator() == null || !StringUtils.isNotBlank((CharSequence)page.getCreator().getEmail())) break;
                result.add(page.getCreator().getEmail());
                break;
            }
            case LAST_MODIFIER: {
                if (page.getLastModifier() == null || !StringUtils.isNotBlank((CharSequence)page.getLastModifier().getEmail())) break;
                result.add(page.getLastModifier().getEmail());
                break;
            }
            case SPACE_LEAD: {
                if (page.getSpace() == null) break;
                this.spaceManager.getSpaceAdmins(page.getSpace()).stream().forEach(user -> {
                    if (user != null && StringUtils.isNotBlank((CharSequence)user.getEmail()) && !result.contains(user.getEmail())) {
                        result.add(user.getEmail());
                    }
                });
                break;
            }
            case WATCHERS: {
                List notifications = this.notificationManager.getNotificationsByContent((ContentEntityObject)page);
                for (Notification notification : notifications) {
                    if (notification.getReceiver() == null || !StringUtils.isNotBlank((CharSequence)notification.getReceiver().getEmail())) continue;
                    result.add(notification.getReceiver().getEmail());
                }
                break;
            }
        }
        return result;
    }

    public DataRuleHistoryModel runDataRule(int dataRuleId) throws Exception {
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        log.debug("Start execution Recurring task '" + dataRuleId + "'");
        DataRuleEntity dataRuleEntity = this.dataRuleDao.getById(dataRuleId);
        if (dataRuleEntity == null) {
            throw new Exception("DataRuleEntity " + dataRuleId + " not found");
        }
        log.debug("Task found, name = '" + dataRuleEntity.getName() + "'");
        this.pluginSettings.put(String.valueOf(dataRuleEntity.getID()), (Object)String.valueOf(new Date().getTime()));
        ConfluenceUser serviceUser = this.userManager.getUserByName(this.GDPRSettingsManager.getRunTasksFromUser());
        if (serviceUser != null) {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)serviceUser);
            log.debug("Service user found, set userThreadLocal for user = '" + serviceUser.getName() + "'");
        } else {
            log.debug("No valid serviceUser, please check addon parameters. Recurring tasks will be disabled");
        }
        log.debug("Validating cql query, cql = '" + dataRuleEntity.getCql() + "'");
        Optional<String> cqlValidationStatusModel = this.cqlManager.isCqlValid(dataRuleEntity.getCql());
        if (cqlValidationStatusModel.isPresent()) {
            this.dataRuleDao.disableRule(dataRuleEntity.getID());
            return this.dataRuleHistoryService.createEntity(dataRuleEntity.getID(), "Cannot execute the rule because CQL is not valid! This rule will be disabled! " + cqlValidationStatusModel.get(), "", 2);
        }
        if (serviceUser == null) {
            this.dataRuleDao.disableRule(dataRuleEntity.getID());
            return this.dataRuleHistoryService.createEntity(dataRuleEntity.getID(), "Cannot execute the rule because service user is not valid! This rule will be disabled!", "", 2);
        }
        log.debug("If you see this message, validating was successful");
        List<AbstractPage> pages = this.cqlManager.getContentFromCql(dataRuleEntity.getCql(), false);
        log.debug("Found " + pages.size() + " pages, processing...");
        if (pages.size() > 0) {
            log.debug("Getting pageIds string...");
            String pageIds = this.getPageIds(pages);
            log.debug("Result = '" + pageIds + "'");
            log.debug("Getting task parameters...");
            Type mapType = new TypeToken<Map<String, String>>(){}.getType();
            Map parameters = (Map)new Gson().fromJson(dataRuleEntity.getParameters(), mapType);
            Map<String, String> notificationParameters = this.jsonStringToMap(dataRuleEntity.getNotificationParameters());
            log.debug("Found parameters = '" + parameters.toString() + "'");
            log.debug("Found notificationParameters = '" + notificationParameters + "'");
            String historyDetails = "";
            int resultCode = 0;
            ActionType type = ActionType.fromString(dataRuleEntity.getType());
            log.debug("Found actionType = '" + (Object)((Object)type) + "'");
            switch (type) {
                case NOTIFICATION: {
                    List<Object> emails;
                    log.debug("Working with NOTIFICATION type...");
                    historyDetails = "Trying to send notification about " + pages.size() + " affected pages.";
                    String subject = (String)parameters.get("subject");
                    String notRenderedMessage = (String)parameters.get("message");
                    log.debug("subject = '" + subject);
                    log.debug("notRenderedMessage = '" + notRenderedMessage);
                    ActionNotificationUserType userType = ActionNotificationUserType.fromString((String)parameters.get("notification"));
                    log.debug("userType = '" + (Object)((Object)userType) + "'");
                    String grouping = (String)parameters.get("grouping");
                    log.debug("grouping = '" + grouping + "'");
                    if ("default".equals(grouping)) {
                        log.debug("Processing pages...");
                        for (AbstractPage abstractPage : pages) {
                            log.debug("Processing '" + abstractPage.getId() + ":" + abstractPage.getTitle() + "'...");
                            emails = userType == ActionNotificationUserType.EXTERNAL_EMAILS ? Lists.newArrayList(((String)parameters.get("externalEmails")).split(",")) : this.getEmailsForPage(abstractPage, userType);
                            log.debug("Found " + emails.size() + " emails for sending, trying to send");
                            for (String string : emails) {
                                log.debug("Sending to '" + string + "'...");
                                String errorMessage = this.emailManager.sendMessage(subject, this.renderMessage(notRenderedMessage, abstractPage), string);
                                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                                    log.debug("Successfully sent to '" + string + "'");
                                    historyDetails = historyDetails + "Successfully sent to '" + string + "'. ";
                                    continue;
                                }
                                log.debug("Failed to send to '" + string + "', because of '" + errorMessage + "'");
                                resultCode = 1;
                                historyDetails = historyDetails + "Cannot sent to '" + string + "'  " + errorMessage + ". ";
                            }
                        }
                        log.debug("Finish processing pages");
                        break;
                    }
                    HashMap emailWithSpace = new HashMap();
                    HashMap hashMap = new HashMap();
                    emails = new ArrayList();
                    if (userType == ActionNotificationUserType.EXTERNAL_EMAILS) {
                        emails = Lists.newArrayList(((String)parameters.get("externalEmails")).split(","));
                        log.debug("ActionNotificationUserType = 'EXTERNAL_EMAILS', found " + emails.size() + "' emails");
                    }
                    log.debug("Processing pages...");
                    for (AbstractPage abstractPage : pages) {
                        log.debug("Processing '" + abstractPage.getId() + ":" + abstractPage.getTitle() + "'...");
                        if (userType != ActionNotificationUserType.EXTERNAL_EMAILS) {
                            emails = this.getEmailsForPage(abstractPage, userType);
                            log.debug("Found " + emails.size() + " emails for sending");
                        }
                        log.debug("Trying to get spaceKey for page");
                        String spaceKey = abstractPage.getSpaceKey();
                        if (!hashMap.containsKey(spaceKey)) {
                            hashMap.put(spaceKey, new LinkedList());
                            log.debug("Found '" + spaceKey + "' spaceKey, added new item to the spaceWithPages, new size = " + hashMap.size());
                        } else {
                            log.debug("Found '" + spaceKey + "' spaceKey, already exists in the spaceWithPages");
                        }
                        log.debug("Getting pageAsRow...");
                        String string = this.renderPageRow(abstractPage);
                        log.debug("Found string = '" + string + "'");
                        if (!((List)hashMap.get(spaceKey)).contains(string)) {
                            ((List)hashMap.get(spaceKey)).add(string);
                            log.debug("Added new item to the related list for spaceKey '" + spaceKey + "', new size = " + ((List)hashMap.get(spaceKey)).size());
                        } else {
                            log.debug("Already exists in the related list for spaceKey '" + spaceKey + "'");
                        }
                        log.debug("Creating emailWithSpace object...");
                        if (emails.size() > 0) {
                            for (String string2 : emails) {
                                if (!emailWithSpace.containsKey(string2)) {
                                    emailWithSpace.put(string2, new LinkedList());
                                }
                                if (((List)emailWithSpace.get(string2)).contains(spaceKey)) continue;
                                ((List)emailWithSpace.get(string2)).add(spaceKey);
                            }
                        }
                        log.debug("Created, size = " + emailWithSpace.size());
                    }
                    log.debug("Trying to send emails depending on grouping...");
                    if ("group-by-user".equals(grouping)) {
                        log.debug("Working with 'group-by-user' grouping...");
                        for (Map.Entry entry : emailWithSpace.entrySet()) {
                            String rows = "";
                            String string = (String)entry.getKey();
                            for (String string3 : (List)entry.getValue()) {
                                if (!hashMap.containsKey(string3)) continue;
                                rows = rows + String.join((CharSequence)"\n", (Iterable)hashMap.get(string3));
                            }
                            log.debug("rows = '" + rows + "'");
                            if (!StringUtils.isNotBlank((CharSequence)rows)) continue;
                            log.debug("Trying to send email to '" + string + "'");
                            String errorMessage = this.emailManager.sendMessage(subject, this.renderResultTable(notRenderedMessage, rows), string);
                            if (StringUtils.isBlank((CharSequence)errorMessage)) {
                                log.debug("Successfully sent to '" + string + "'");
                                historyDetails = historyDetails + "Successfully sent to '" + string + "'. ";
                                continue;
                            }
                            log.debug("Failed to sent email to '" + string + "', because of '" + errorMessage + "'");
                            resultCode = 1;
                            historyDetails = historyDetails + "Cannot sent to '" + string + "'  " + errorMessage + ". ";
                        }
                        log.debug("Emails sent");
                        break;
                    }
                    if (!"group-by-space".equals(grouping)) break;
                    log.debug("Working with 'group-by-space' grouping...");
                    for (Map.Entry entry : emailWithSpace.entrySet()) {
                        String email = (String)entry.getKey();
                        for (String spaceKey : (List)entry.getValue()) {
                            if (!hashMap.containsKey(spaceKey)) continue;
                            String string = String.join((CharSequence)"\n", (Iterable)hashMap.get(spaceKey));
                            log.debug("rows = '" + string + "'");
                            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                            log.debug("Truing to send email to '" + (String)email + "'");
                            String errorMessage = this.emailManager.sendMessage(subject, this.renderResultTable(notRenderedMessage, string), email);
                            if (StringUtils.isBlank((CharSequence)errorMessage)) {
                                log.debug("Successfully sent to '" + (String)email + "'");
                                historyDetails = historyDetails + "Successfully sent to '" + (String)email + "'. ";
                                continue;
                            }
                            log.debug("Failed to sent email to '" + (String)email + "', because of '" + errorMessage + "'");
                            resultCode = 1;
                            historyDetails = historyDetails + "Cannot sent to '" + (String)email + "'  " + errorMessage + ". ";
                        }
                    }
                    break;
                }
                case COMMENT: {
                    log.debug("Working with COMMENT type...");
                    historyDetails = "Trying to create comment to " + pages.size() + " affected pages. ";
                    log.debug("Processing pages...");
                    for (ContentEntityObject contentEntityObject : pages) {
                        log.debug("Processing '" + contentEntityObject.getId() + ":" + contentEntityObject.getTitle() + "'...");
                        try {
                            Comment comment = new Comment();
                            comment.setBodyAsString((String)parameters.get("comment"));
                            comment.setCreationDate(new Date());
                            comment.setCreator(serviceUser);
                            contentEntityObject.addComment(comment);
                            this.pageManager.saveContentEntity((ContentEntityObject)comment, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                            log.debug("New comment successfully created");
                            historyDetails = historyDetails + contentEntityObject.getId() + " done. ";
                        }
                        catch (Exception e) {
                            resultCode = 1;
                            historyDetails = historyDetails + "Cannot create comment to " + contentEntityObject.getId() + " - " + e.getMessage() + ". ";
                            log.error(e.getMessage());
                        }
                    }
                    break;
                }
                case TRASH: {
                    DataRuleActionExecutionResultModel trashActionResult = this.trashAction(pages, parameters);
                    historyDetails = trashActionResult.getHistoryDetails();
                    resultCode = trashActionResult.getResultCode();
                    break;
                }
                case DELETE: {
                    DataRuleActionExecutionResultModel dataRuleActionExecutionResultModel = this.deleteAction(pages, parameters);
                    historyDetails = dataRuleActionExecutionResultModel.getHistoryDetails();
                    resultCode = dataRuleActionExecutionResultModel.getResultCode();
                    break;
                }
                case SECURITY: {
                    historyDetails = "Trying to set permissions to " + pages.size() + " affected pages. ";
                    for (ContentEntityObject contentEntityObject : pages) {
                        ArrayList<ContentPermission> arrayList = Lists.newArrayList(new ContentPermission[0]);
                        if (contentEntityObject.getContentPermissionSet("View") != null) {
                            for (ContentPermission contentPermission : contentEntityObject.getContentPermissionSet("View")) {
                                arrayList.add(contentPermission);
                            }
                            for (ContentPermission contentPermission : arrayList) {
                                this.contentPermissionManager.removeContentPermission(contentPermission);
                            }
                        }
                        ArrayList<ContentPermission> editPermissionsToDelete = Lists.newArrayList(new ContentPermission[0]);
                        if (contentEntityObject.getContentPermissionSet("Edit") != null) {
                            for (ContentPermission contentPermission2 : contentEntityObject.getContentPermissionSet("Edit")) {
                                editPermissionsToDelete.add(contentPermission2);
                            }
                            for (ContentPermission contentPermission : editPermissionsToDelete) {
                                this.contentPermissionManager.removeContentPermission(contentPermission);
                            }
                        }
                        ContentPermission contentPermission = ContentPermission.createGroupPermission((String)"View", (String)((String)parameters.get("group")));
                        this.contentPermissionManager.addContentPermission(contentPermission, contentEntityObject);
                        ContentPermission contentPermissionEdit = ContentPermission.createGroupPermission((String)"Edit", (String)((String)parameters.get("group")));
                        this.contentPermissionManager.addContentPermission(contentPermissionEdit, contentEntityObject);
                        historyDetails = historyDetails + contentEntityObject.getId() + " done. ";
                    }
                    break;
                }
            }
            String notificationTypeAsText = dataRuleEntity.getNotificationType();
            NotificationType notificationType = NotificationType.fromString(notificationTypeAsText);
            switch (notificationType) {
                case EMAIL: {
                    String subject = "Pages affected by Data Protection rule";
                    String body = this.getMailBody(pages, dataRuleEntity.getName());
                    ArrayList<String> emails = Lists.newArrayList(notificationParameters.get("emails").split(","));
                    for (String email : emails) {
                        String string = this.emailManager.sendMessage(subject, body, email);
                        if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                        log.error("Cannot send email to {}. {}", (Object)email, (Object)string);
                    }
                    break;
                }
                case LOGGING: {
                    log.info("Rule {} '{}' has been executed", (Object)dataRuleId, (Object)dataRuleEntity.getName());
                    log.info("Total pages found: {}", (Object)pages.size());
                    log.info("Processed status: {}", (Object)historyDetails);
                    break;
                }
            }
            return this.dataRuleHistoryService.createEntity(dataRuleEntity.getID(), historyDetails, pageIds, resultCode);
        }
        log.debug("Finished");
        return null;
    }

    private DataRuleActionExecutionResultModel deleteAction(List<AbstractPage> pages, Map<String, String> parameters) {
        List<Long> pageIds = pages.stream().map(page -> page.getId()).collect(Collectors.toList());
        String historyDetails = "Trying to delete " + pages.size() + " affected pages. ";
        int resultCode = 0;
        boolean deleteWithAllChild = StringUtils.isBlank((CharSequence)parameters.get("deleteOption")) || Objects.equals(parameters.get("deleteOption"), "delete-options-with-all-child");
        boolean deleteOnlyIfAllChildAffected = Objects.equals(parameters.get("deleteOption"), "delete-options-only-if-all-affected");
        boolean deleteAndMoveChildToNearestParent = Objects.equals(parameters.get("deleteOption"), "delete-options-and-move-child-to-parents");
        Iterator iterator = pageIds.iterator();
        while (iterator.hasNext()) {
            long pageId = (Long)iterator.next();
            try {
                if (deleteWithAllChild) {
                    this.deletePageWithAllChildren(pageId, true);
                    historyDetails = historyDetails + pageId + " deleted. ";
                }
                if (deleteOnlyIfAllChildAffected) {
                    boolean isAllChildrenAreAffected = this.isAllChildrenAreAffected(pageIds, pageId);
                    log.error("isAllChildrenAreAffected = " + isAllChildrenAreAffected);
                    if (isAllChildrenAreAffected) {
                        this.deletePageWithAllChildren(pageId, true);
                        historyDetails = historyDetails + pageId + " deleted. ";
                    } else {
                        resultCode = 1;
                        historyDetails = historyDetails + "Cannot delete page " + pageId + " - Not all the children are affected by CQL. ";
                    }
                }
                if (!deleteAndMoveChildToNearestParent) continue;
                this.moveChildPagesToHighestParent(pageId);
                this.deletePage(pageId, true);
                historyDetails = historyDetails + pageId + " deleted. ";
            }
            catch (Exception e) {
                resultCode = 1;
                historyDetails = historyDetails + "Cannot delete page " + pageId + " - " + e.getMessage() + ". ";
            }
        }
        return new DataRuleActionExecutionResultModel(historyDetails, resultCode);
    }

    private void moveChildPagesToHighestParent(long parentPageId) {
        List pageList;
        log.debug("Move children to highest parent, current page id = " + parentPageId);
        Page parentContent = this.pageManager.getPage(parentPageId);
        if (parentContent != null && (pageList = this.pageManager.getDescendants(parentContent)).size() > 0) {
            this.pageManager.moveChildrenToNewParent(parentContent, parentContent.getParent());
        }
    }

    private boolean isAllChildrenAreAffected(List<Long> affectedPageIds, long parentPageId) throws Exception {
        List pageList;
        log.debug("isAllChildrenAreAffected, parentPageId = " + parentPageId);
        boolean isAllChildrenAreAffected = true;
        Page parentContent = this.pageManager.getPage(parentPageId);
        if (parentContent != null && (pageList = this.pageManager.getDescendants(parentContent)).size() > 0) {
            for (Page childPage : pageList) {
                if (affectedPageIds.contains(childPage.getId())) continue;
                isAllChildrenAreAffected = false;
            }
        }
        return isAllChildrenAreAffected;
    }

    private void deletePageWithAllChildren(long parentContentEntityObjectId, boolean permanentlyDelete) throws Exception {
        log.debug("Recursive page search for deletion, id = " + parentContentEntityObjectId);
        ContentEntityObject parentContent = this.pageManager.getById(parentContentEntityObjectId);
        if (parentContent != null) {
            List pageList;
            if (parentContent instanceof Page && !(pageList = this.pageManager.getDescendants((Page)parentContent)).isEmpty()) {
                for (Page page : pageList) {
                    this.deletePageWithAllChildren(page.getId(), permanentlyDelete);
                }
            }
            this.deletePage(parentContent.getId(), permanentlyDelete);
        }
    }

    private void deletePage(long contentEntityObjectId, boolean permanentlyDelete) throws Exception {
        log.debug("Trying to delete page, id = " + contentEntityObjectId);
        ContentEntityObject page = this.pageManager.getById(contentEntityObjectId);
        if (page != null) {
            this.pageManager.trashPage((AbstractPage)page, DefaultDeleteContext.SUPPRESS_NOTIFICATIONS);
            if (permanentlyDelete) {
                this.trashManager.purge(((AbstractPage)page).getSpaceKey(), page.getId());
            }
        } else {
            throw new Exception("Page not found, id = " + contentEntityObjectId);
        }
    }

    private DataRuleActionExecutionResultModel trashAction(List<AbstractPage> pages, Map<String, String> parameters) {
        List<Long> pageIds = pages.stream().map(page -> page.getId()).collect(Collectors.toList());
        String historyDetails = "Trying to move to the space trash " + pages.size() + " affected pages. ";
        int resultCode = 0;
        boolean deleteWithAllChild = StringUtils.isBlank((CharSequence)parameters.get("trashOption")) || Objects.equals(parameters.get("trashOption"), "trash-options-with-all-child");
        boolean deleteOnlyIfAllChildAffected = Objects.equals(parameters.get("trashOption"), "trash-options-only-if-all-affected");
        boolean deleteAndMoveChildToNearestParent = Objects.equals(parameters.get("trashOption"), "trash-options-and-move-child-to-parents");
        Iterator iterator = pageIds.iterator();
        while (iterator.hasNext()) {
            long pageId = (Long)iterator.next();
            try {
                if (deleteWithAllChild) {
                    this.deletePageWithAllChildren(pageId, false);
                    historyDetails = historyDetails + pageId + " moved to trash. ";
                }
                if (deleteOnlyIfAllChildAffected) {
                    boolean isAllChildrenAreAffected = this.isAllChildrenAreAffected(pageIds, pageId);
                    log.debug("isAllChildrenAreAffected = " + isAllChildrenAreAffected);
                    if (isAllChildrenAreAffected) {
                        this.deletePageWithAllChildren(pageId, false);
                        historyDetails = historyDetails + pageId + " moved to trash. ";
                    } else {
                        resultCode = 1;
                        historyDetails = historyDetails + "Cannot move a page to trash " + pageId + " - Not all the children are affected by CQL. ";
                    }
                }
                if (!deleteAndMoveChildToNearestParent) continue;
                this.moveChildPagesToHighestParent(pageId);
                this.deletePage(pageId, false);
                historyDetails = historyDetails + pageId + " moved to trash. ";
            }
            catch (Exception e) {
                resultCode = 1;
                historyDetails = historyDetails + "Cannot move a page to trash " + pageId + " - " + e.getMessage() + ". ";
            }
        }
        return new DataRuleActionExecutionResultModel(historyDetails, resultCode);
    }

    private String renderMessage(String notRenderedMessage, AbstractPage page) {
        if (notRenderedMessage.contains("$linkToPage")) {
            notRenderedMessage = notRenderedMessage.replace("$linkToPage", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/pages/viewpage.action?pageId=" + page.getId());
        }
        if (notRenderedMessage.contains("$pageTitle")) {
            notRenderedMessage = notRenderedMessage.replace("$pageTitle", page.getTitle());
        }
        if (notRenderedMessage.contains("$spaceName")) {
            notRenderedMessage = notRenderedMessage.replace("$spaceName", page.getSpace().getName());
        }
        if (notRenderedMessage.contains("$spaceKey")) {
            notRenderedMessage = notRenderedMessage.replace("$spaceKey", page.getSpaceKey());
        }
        return notRenderedMessage;
    }

    private String renderResultTable(String notRenderedMessage, String rows) {
        String message = "<table><thead><th>Space</th><th>Page</th></thead>";
        message = message + rows;
        message = message + "</table>";
        return notRenderedMessage.replace("$resultTable", message);
    }

    private String renderPageRow(AbstractPage page) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
        context.put("space", page.getSpace().getName());
        context.put("spaceKey", page.getSpaceKey());
        context.put("pageId", page.getId());
        context.put("pageTitle", page.getTitle());
        return VelocityUtils.getRenderedTemplate((String)"templates/email/page-row.vm", context);
    }

    private String getMailBody(List<AbstractPage> pages, String ruleName) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("pages", pages);
        context.put("ruleName", ruleName);
        context.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
        return VelocityUtils.getRenderedTemplate((String)"templates/email/pages-selected-by-data-rule.vm", (Map)context);
    }

    private String getPageIds(List<AbstractPage> pages) {
        String result = pages.stream().map(page -> page.getTitle() + " (" + page.getId() + ")").collect(Collectors.joining(",", " ", ""));
        return result;
    }
}

