/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomConditionService {
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager GDPRSettingsManager;

    @Autowired
    public CustomConditionService(UserAccessor userAccessor, GDPRSettingsManager GDPRSettingsManager2) {
        this.userAccessor = userAccessor;
        this.GDPRSettingsManager = GDPRSettingsManager2;
    }

    public boolean shouldDisplay() {
        String username = AuthenticatedUserThreadLocal.getUsername();
        String runGdprGroup = this.GDPRSettingsManager.getAllowedGroup();
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)runGdprGroup)) {
            return true;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        return this.userAccessor.hasMembership(runGdprGroup, user.getName());
    }
}

