/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.component.manager.AnnouncingDao;
import de.actonic.confluence.gdpr.component.manager.AnnouncingHistoryDao;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.confluence.gdpr.util.Maps;
import de.actonic.gdpr.shared.general.exception.GDPRNotFoundException;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncingService {
    private static final Logger log = LoggerFactory.getLogger(AnnouncingService.class);
    public static final String CACHE_NAME = "get-announcement-for-user-cache";
    private static final String ANNOUNCING_EDITOR = "announcing-editor";
    private static final String ANNOUNCING_PAGE = "announcing-page";
    private final AnnouncingDao announcingDao;
    private final AnnouncingHistoryDao announcingHistoryDao;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PageManager pageManager;
    private final Cache<String, String> nextAnnouncementCache;
    private final IGDPRUserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public AnnouncingService(AnnouncingDao announcingDao, AnnouncingHistoryDao announcingHistoryDao, UserAccessor userAccessor, PageManager pageManager, @ComponentImport CacheManager cacheManager, IGDPRUserManager userManager, I18nResolver i18n) {
        this.announcingDao = announcingDao;
        this.announcingHistoryDao = announcingHistoryDao;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.nextAnnouncementCache = cacheManager.getCache(CACHE_NAME);
        this.userManager = userManager;
        this.i18n = i18n;
    }

    public List<AnnouncingModel> getAnnouncingItems() {
        ArrayList<AnnouncingModel> announcingModels = Lists.newArrayList(new AnnouncingModel[0]);
        List<AnnouncingEntity> announcingEntities = this.announcingDao.getAllEntities();
        announcingEntities.forEach(announcingEntity -> {
            HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
            announcingModels.add(new AnnouncingModel((AnnouncingEntity)announcingEntity, extraFields));
        });
        return announcingModels;
    }

    public List<AnnouncingModel> getAnnouncingItemsByPartName(String partName) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        List<AnnouncingModel> activeAnnouncingItems = this.getAnnouncingItems();
        ArrayList<AnnouncingModel> resultAnnouncingItemsList = new ArrayList<AnnouncingModel>();
        for (AnnouncingModel item : activeAnnouncingItems) {
            if (!StringUtils.containsIgnoreCase((CharSequence)item.getName(), (CharSequence)partName)) continue;
            resultAnnouncingItemsList.add(item);
        }
        return resultAnnouncingItemsList;
    }

    public List<AnnouncingModel> getActiveAnnouncingItems() {
        ArrayList<AnnouncingModel> announcingModels = Lists.newArrayList(new AnnouncingModel[0]);
        List<AnnouncingEntity> announcingEntities = this.announcingDao.getActiveEntities();
        announcingEntities.forEach(announcingEntity -> {
            HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
            announcingModels.add(new AnnouncingModel((AnnouncingEntity)announcingEntity, extraFields));
        });
        return announcingModels;
    }

    public AnnouncingModel getNextAnnouncingItemForUser(ConfluenceUser applicationUser, String cookieAnnouncings) {
        String hash = "" + Math.round(Math.random() * 100000.0 + Math.random() * 10000.0 + Math.random() * 1000.0 + Math.random() * 100.0 + Math.random() * 10.0);
        String cacheKey = applicationUser != null ? applicationUser.getKey().getStringValue() + ":::next" : "anonymous-" + cookieAnnouncings + ":::next";
        log.debug(hash + " | getting next announcement for cacheKey = '" + cacheKey + "'");
        log.debug(hash + " | isCacheContainsKey = " + this.nextAnnouncementCache.containsKey((Object)cacheKey));
        if (this.nextAnnouncementCache.containsKey((Object)cacheKey)) {
            log.debug(hash + " | isFoundInCache = true");
            return this.getNextAnnouncingItemForUserFromCache(cacheKey);
        }
        AnnouncingModel announcingModel = this.getNextAnnouncingItemForUserNoCache(applicationUser, cookieAnnouncings, hash);
        if (announcingModel != null) {
            this.nextAnnouncementCache.put((Object)cacheKey, (Object)this.announcingModelsToJson(Lists.newArrayList(announcingModel)));
            log.debug(hash + " | isAddedToCache = " + this.nextAnnouncementCache.containsKey((Object)cacheKey));
            log.debug(hash + " | will be returned result '" + announcingModel.getId() + ":" + announcingModel.getName() + "'");
        } else {
            this.nextAnnouncementCache.put((Object)cacheKey, (Object)this.announcingModelsToJson(Lists.newArrayList(new AnnouncingModel[0])));
            log.debug(hash + " | no found returned announcements, null will be returned");
        }
        return announcingModel;
    }

    private AnnouncingModel getNextAnnouncingItemForUserNoCache(ConfluenceUser applicationUser, String cookieAnnouncings, String hash) {
        log.debug("getting NOT from cache");
        List<String> announcings = cookieAnnouncings != null ? Arrays.asList(cookieAnnouncings.split("-")) : Lists.newArrayList(new String[0]);
        List<AnnouncingEntity> announcingEntities = this.announcingDao.getActiveEntities();
        log.debug(hash + " | found " + announcingEntities.size() + " active announcements");
        for (AnnouncingEntity announcingEntity : announcingEntities) {
            log.debug(hash + " | working with announcement '" + announcingEntity.getID() + ":" + announcingEntity.getName() + "'");
            if (applicationUser == null && announcingEntity.getIsAnonymous() && !announcings.contains(Integer.toString(announcingEntity.getID()))) {
                log.debug(hash + " | working with anonymize announcements.");
                HashMap<String, Object> extraFields = Maps.getMapData("isLoggedIn", Boolean.FALSE);
                AnnouncingModel model = new AnnouncingModel(announcingEntity, extraFields);
                log.debug(hash + " | will be returned result '" + model.getId() + ":" + model.getName() + "'");
                return model;
            }
            if (applicationUser == null || announcingEntity.getIsAnonymous()) continue;
            log.debug(hash + " | working with user announcements, for user = '" + applicationUser.getName() + " (" + applicationUser.getKey().getStringValue() + ")'");
            List groupNamesForUserName = this.userAccessor.getGroupNamesForUserName(applicationUser.getName());
            log.debug(hash + " | found groups for user = '" + groupNamesForUserName.toString() + "'");
            boolean isUserAcceptedAnnouncing = this.announcingHistoryDao.isUserAcceptedAnnouncing(applicationUser.getKey().getStringValue(), announcingEntity.getID());
            log.debug(hash + " | isUserAcceptedAnnouncing = " + isUserAcceptedAnnouncing);
            log.debug(hash + " | isUserInGroup = " + (StringUtils.isEmpty((CharSequence)announcingEntity.getGroup()) || groupNamesForUserName.contains(announcingEntity.getGroup())));
            if (!StringUtils.isEmpty((CharSequence)announcingEntity.getGroup()) && !groupNamesForUserName.contains(announcingEntity.getGroup()) || isUserAcceptedAnnouncing) continue;
            log.debug(hash + " | announcing for showing found");
            HashMap<String, Object> extraFields = Maps.getMapData("isLoggedIn", Boolean.TRUE);
            AnnouncingModel model = new AnnouncingModel(announcingEntity, extraFields);
            return model;
        }
        return null;
    }

    private AnnouncingModel getNextAnnouncingItemForUserFromCache(String cacheKey) {
        log.debug("getting from cache " + cacheKey);
        List<AnnouncingModel> result = this.jsonToAnnouncingModels((String)this.nextAnnouncementCache.get((Object)cacheKey));
        log.debug(cacheKey + " | found " + (result != null ? Integer.valueOf(result.size()) : "null") + " results, " + result);
        if (result != null && result.size() > 0) {
            log.debug(cacheKey + " | will be returned result '" + result.get(0).getId() + ":" + result.get(0).getName() + "'");
            return result.get(0);
        }
        return null;
    }

    public AnnouncingModel getAnnouncingItem(int id) {
        AnnouncingEntity announcingEntity = this.announcingDao.getById(id);
        if (announcingEntity == null) {
            throw new GDPRNotFoundException("Announcement with id: " + id + "not found");
        }
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    public AnnouncingModel clearAnnouncing(int id) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        AnnouncingEntity announcingEntity = this.announcingDao.getById(id);
        if (announcingEntity == null) {
            throw new GDPRNotFoundException("Announcement with id: " + id + "not found");
        }
        this.nextAnnouncementCache.removeAll();
        this.announcingHistoryDao.clearAnnouncing(id);
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    public void deleteAnnouncingItem(int id) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.nextAnnouncementCache.removeAll();
        this.announcingDao.deleteEntity(id);
    }

    public AnnouncingModel createAnnouncing(ConfluenceUser applicationUser, boolean isActive, Date startDate, Date endDate, String name, String type, String style, String group, boolean isQuestionnaire, boolean isAnonymous, String windowSize, String accept, String decline, boolean isPinned, String title, String content, Long pageId, String body) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.nextAnnouncementCache.removeAll();
        if (content.toUpperCase().equals(ANNOUNCING_EDITOR)) {
            pageId = null;
            body = this.cleanHtml(body);
        } else if (content.toUpperCase().equals(ANNOUNCING_PAGE)) {
            body = "";
        }
        AnnouncingEntity announcingEntity = this.announcingDao.createEntity(isActive, startDate, endDate, name, type, style, applicationUser.getKey().getStringValue(), new Date(), new Date(), applicationUser.getKey().getStringValue(), group, isQuestionnaire, isAnonymous, windowSize, accept, decline, isPinned, title, content, pageId, body);
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", 0, "declined", 0);
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    public AnnouncingModel updateAnnouncing(int id, ConfluenceUser applicationUser, boolean isActive, Date startDate, Date endDate, String name, String type, String style, String group, boolean isQuestionnaire, boolean isAnonymous, String windowSize, String accept, String decline, boolean isPinned, String title, String content, Long pageId, String body) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.nextAnnouncementCache.removeAll();
        if (content.toUpperCase().equals(ANNOUNCING_EDITOR)) {
            pageId = null;
            body = this.cleanHtml(body);
        } else if (content.toUpperCase().equals(ANNOUNCING_PAGE)) {
            body = "";
        }
        AnnouncingEntity announcingEntity = this.announcingDao.updateEntity(id, isActive, startDate, endDate, name, type, style, new Date(), applicationUser.getKey().getStringValue(), group, isQuestionnaire, isAnonymous, windowSize, accept, decline, isPinned, title, content, pageId, body);
        if (announcingEntity == null) {
            throw new GDPRNotFoundException("Announcement with id: " + id + "not found");
        }
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    private AnnouncingModel createTemplateAnnouncing(int id) {
        this.nextAnnouncementCache.removeAll();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InputStream inputStream = null;
        if (id == 1) {
            inputStream = this.getClass().getResourceAsStream("/assets/sample-announcement-privacy.txt");
        } else if (id == 2) {
            inputStream = this.getClass().getResourceAsStream("/assets/sample-announcement-cookie.txt");
        }
        String result = null;
        try {
            result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result == null) {
            result = "Sample body";
        }
        AnnouncingEntity announcingEntity = null;
        if (id == 1) {
            announcingEntity = this.announcingDao.createEntity(Boolean.FALSE, null, null, "Privacy policy", "optional", "center", confluenceUser.getKey().getStringValue(), new Date(), new Date(), null, null, Boolean.FALSE, Boolean.FALSE, "medium", "Accept", "Decline", Boolean.TRUE, "Privacy policy", ANNOUNCING_EDITOR, null, result);
        } else if (id == 2) {
            announcingEntity = this.announcingDao.createEntity(Boolean.FALSE, null, null, "Cookie policy", "optional", "bottom", confluenceUser.getKey().getStringValue(), new Date(), new Date(), null, null, Boolean.FALSE, Boolean.FALSE, "medium", "Accept", "Decline", Boolean.TRUE, "Cookie policy", ANNOUNCING_EDITOR, null, result);
        }
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", 0, "declined", 0);
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    public AnnouncingModel createTemplateAnnoucing(int id) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        log.debug("createTemplateAnnouncing = " + id);
        AnnouncingModel announcingModel = this.createTemplateAnnouncing(id);
        return announcingModel;
    }

    public AnnouncingModel updateStatus(int id, boolean isActive) {
        this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        this.nextAnnouncementCache.removeAll();
        AnnouncingEntity announcingEntity = this.announcingDao.updateStatus(id, isActive);
        if (announcingEntity == null) {
            throw new GDPRNotFoundException("Announcement with id: " + id + "not found");
        }
        HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()));
        return new AnnouncingModel(announcingEntity, extraFields);
    }

    public boolean isHtmlValid(String html) {
        return StringUtils.isNotBlank((CharSequence)html);
    }

    private String cleanHtml(String html) {
        return Jsoup.clean((String)html, (Whitelist)Whitelist.relaxed());
    }

    public List<AnnouncingModel> getPinnedAnnouncements(ConfluenceUser applicationUser) {
        String hash = "" + Math.round(Math.random() * 100000.0 + Math.random() * 10000.0 + Math.random() * 1000.0 + Math.random() * 100.0 + Math.random() * 10.0);
        String cacheKey = applicationUser != null ? applicationUser.getKey().getStringValue() + ":::pinned" : "anonymous:::pinned";
        log.debug(hash + " | getting next announcement for cacheKey = '" + cacheKey + "'");
        log.debug(hash + " | isCacheContainsKey = " + this.nextAnnouncementCache.containsKey((Object)cacheKey));
        if (cacheKey != null && this.nextAnnouncementCache.containsKey((Object)cacheKey)) {
            List<AnnouncingModel> announcingModels = this.jsonToAnnouncingModels((String)this.nextAnnouncementCache.get((Object)cacheKey));
            log.debug(hash + " | isFoundInCache = true, found " + announcingModels.size() + " elements");
            return announcingModels;
        }
        log.debug(hash + " | isFoundInCache = false, getting from AO...");
        ArrayList<AnnouncingModel> announcingModels = Lists.newArrayList(new AnnouncingModel[0]);
        List<AnnouncingEntity> announcingEntities = this.announcingDao.getPinnedEntities();
        log.debug(hash + " | found " + announcingEntities.size() + " active pinned entities, filtering by groups and users...");
        String action = applicationUser == null ? "acknowledge" : "regular";
        for (AnnouncingEntity announcingEntity : announcingEntities) {
            Boolean shouldShow = announcingEntity.getIsAnonymous() ? applicationUser == null : applicationUser != null && (StringUtils.isBlank((CharSequence)announcingEntity.getGroup()) || this.userAccessor.hasMembership(announcingEntity.getGroup(), applicationUser.getName()));
            log.debug(hash + " | announcement '" + announcingEntity.getID() + ":" + announcingEntity.getName() + "'; shouldShow = " + shouldShow);
            if (!shouldShow.booleanValue()) continue;
            String response = applicationUser != null ? this.announcingHistoryDao.getQueResponse(announcingEntity.getID(), applicationUser.getKey().getStringValue()) : null;
            HashMap<String, Object> extraFields = Maps.getMapData("accepted", this.announcingHistoryDao.getAcceptedCount(announcingEntity.getID()), "declined", this.announcingHistoryDao.getDeclinedCount(announcingEntity.getID()), "action", (Object)action, "response", StringUtils.isBlank((CharSequence)response) ? "" : response);
            announcingModels.add(new AnnouncingModel(announcingEntity, extraFields));
        }
        log.debug(hash + " | will be shown " + announcingModels.size() + " entities");
        this.nextAnnouncementCache.put((Object)cacheKey, (Object)this.announcingModelsToJson(announcingModels));
        log.debug(hash + " | added to the cache '" + cacheKey + "', pinned entities = " + announcingModels.size());
        return announcingModels;
    }

    public Integer getActiveAnnouncementSize() {
        return this.announcingDao.getActiveAnnouncementSize();
    }

    private List<AnnouncingModel> jsonToAnnouncingModels(String json) {
        try {
            Type type = new TypeToken<List<AnnouncingModel>>(){}.getType();
            return (List)new Gson().fromJson(json, type);
        }
        catch (Exception e) {
            this.nextAnnouncementCache.removeAll();
            return Lists.newArrayList(new AnnouncingModel[0]);
        }
    }

    private String announcingModelsToJson(List<AnnouncingModel> announcingModels) {
        try {
            return new Gson().toJson(announcingModels);
        }
        catch (Exception e) {
            return "";
        }
    }

    public Integer getActiveLoginAnnouncementSize() {
        return this.announcingDao.getLoginFormEntities().length;
    }
}

