/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.AnnouncingDao;
import de.actonic.confluence.gdpr.component.manager.AnnouncingHistoryDao;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.confluence.gdpr.model.AnnouncingHistoryModel;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncingHistoryService {
    private static final Logger log = LoggerFactory.getLogger(AnnouncingHistoryService.class);
    private final AnnouncingHistoryDao announcingHistoryDao;
    private final AnnouncingDao announcingDao;
    private final UserNameConvertManager userNameConvertManager;
    @ComponentImport
    private final UserAccessor userManager;
    private final String baseUrl;
    private final Cache<String, List<AnnouncingModel>> cache;

    @Autowired
    public AnnouncingHistoryService(AnnouncingHistoryDao announcingHistoryDao, AnnouncingDao announcingDao, UserNameConvertManager userNameConvertManager, UserAccessor userManager, ApplicationProperties applicationProperties, @ComponentImport CacheManager cacheManager) {
        this.announcingHistoryDao = announcingHistoryDao;
        this.userManager = userManager;
        this.announcingDao = announcingDao;
        this.userNameConvertManager = userNameConvertManager;
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.cache = cacheManager.getCache("get-announcement-for-user-cache");
    }

    public List<AnnouncingHistoryModel> getAnnouncingHistoryItems(long fromDate, long toDate) {
        List<AnnouncingHistoryEntity> announcingHistoryEntities = this.announcingHistoryDao.getAllEntities();
        return this.filterByDates(announcingHistoryEntities, fromDate, toDate);
    }

    public List<AnnouncingHistoryModel> filterAnnouncingHistoryItemsByUser(String userName, long fromDate, long toDate) {
        String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
        List<AnnouncingHistoryEntity> announcingHistoryEntities = this.announcingHistoryDao.getAllEntitiesByUser(userKey);
        return this.filterByDates(announcingHistoryEntities, fromDate, toDate);
    }

    public List<AnnouncingHistoryModel> filterAnnouncingHistoryItemsByAnnouncingId(int id, long fromDate, long toDate) {
        List<AnnouncingHistoryEntity> announcingHistoryEntities = this.announcingHistoryDao.getAllEntitiesByAnnouncingId(id);
        return this.filterByDates(announcingHistoryEntities, fromDate, toDate);
    }

    public List<AnnouncingHistoryModel> filterAnnouncingHistoryItemsByUserAndAnnouncingId(String userName, int id, long fromDate, long toDate) {
        String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
        List<AnnouncingHistoryEntity> announcingHistoryEntities = this.announcingHistoryDao.getAllEntitiesByUserAndAnnouncingId(userKey, id);
        return this.filterByDates(announcingHistoryEntities, fromDate, toDate);
    }

    private List<AnnouncingHistoryModel> filterByDates(List<AnnouncingHistoryEntity> announcingHistoryEntities, long fromDate, long toDate) {
        ArrayList<AnnouncingHistoryModel> resultAnnouncingHistoryModels = Lists.newArrayList(new AnnouncingHistoryModel[0]);
        announcingHistoryEntities.forEach(announcingHistoryEntity -> {
            if (fromDate != 0L && announcingHistoryEntity.getTimeStamp().getTime() < fromDate) {
                return;
            }
            if (toDate != 0L && announcingHistoryEntity.getTimeStamp().getTime() > toDate) {
                return;
            }
            resultAnnouncingHistoryModels.add(this.entityToModel((AnnouncingHistoryEntity)announcingHistoryEntity));
        });
        return resultAnnouncingHistoryModels;
    }

    public void acceptAnnouncing(int id, ConfluenceUser applicationUser, String questionnaire, String ip) {
        if (applicationUser != null) {
            log.debug("Trying to ACCEPT announcement with id = " + id + ", for user = '" + applicationUser.getName() + " (" + applicationUser.getKey().getStringValue() + ")'");
        } else {
            log.debug("Trying to ACCEPT announcement with id = " + id + ", for anonymous user");
        }
        AnnouncingEntity announcingEntity = this.announcingDao.getById(id);
        if (announcingEntity != null) {
            log.debug("Announcement with id = " + id + " found, name = '" + announcingEntity.getName() + "'");
            String userKey = applicationUser != null ? applicationUser.getKey().getStringValue() : "anonymous";
            log.debug("Trying to create ACCEPT history entity for userKey = '" + userKey + "'");
            if (this.announcingHistoryDao.hasAnswerByIdAndUser(id, userKey)) {
                this.announcingHistoryDao.updateAnnouncingAnswerByIdAndUser(id, "accepted", userKey, questionnaire);
            } else {
                this.announcingHistoryDao.createEntity(id, announcingEntity.getName(), userKey, "accepted", questionnaire, ip);
            }
            log.debug("ACCEPT history entity for userKey = '" + userKey + "' successfully created");
            if (applicationUser != null) {
                String cacheKey = userKey + ":::next";
                log.debug("Trying to remove cache value for cacheKey = '" + cacheKey + "'");
                log.debug("isCacheFoundForKey = " + this.cache.containsKey((Object)cacheKey));
                this.cache.remove((Object)cacheKey);
                log.debug("Cache key has been removed, isCacheFoundForKey = " + this.cache.containsKey((Object)cacheKey));
            }
        } else {
            log.debug("Can not find announcement with such id, skipped");
        }
    }

    public void cancelAnnouncing(int id, ConfluenceUser applicationUser, String questionnaire, String ip) {
        if (applicationUser != null) {
            log.debug("Trying to DECLINE announcement with id = " + id + ", for user = '" + applicationUser.getName() + " (" + applicationUser.getKey().getStringValue() + ")'");
        } else {
            log.debug("Trying to DECLINE announcement with id = " + id + ", for anonymous user");
        }
        AnnouncingEntity announcingEntity = this.announcingDao.getById(id);
        if (announcingEntity != null) {
            log.debug("Announcement with id = " + id + " found, name = '" + announcingEntity.getName() + "'");
            String userKey = applicationUser != null ? applicationUser.getKey().getStringValue() : "anonymous";
            log.debug("Trying to create ACCEPT history entity for userKey = '" + userKey + "'");
            if (this.announcingHistoryDao.hasAnswerByIdAndUser(id, userKey)) {
                this.announcingHistoryDao.updateAnnouncingAnswerByIdAndUser(id, "declined", userKey, questionnaire);
            } else {
                this.announcingHistoryDao.createEntity(id, announcingEntity.getName(), userKey, "declined", questionnaire, ip);
            }
            log.debug("DECLINE history entity for userKey = '" + userKey + "' successfully created");
            if (applicationUser != null) {
                String cacheKey = userKey + ":::next";
                log.debug("Trying to remove cache value for cacheKey = '" + cacheKey + "'");
                log.debug("isCacheFoundForKey = " + this.cache.containsKey((Object)cacheKey));
                this.cache.remove((Object)cacheKey);
                log.debug("Cache key has been removed, isCacheFoundForKey = " + this.cache.containsKey((Object)cacheKey));
            }
        } else {
            log.debug("Can not find announcement with such id, skipped");
        }
    }

    public boolean updatePinnedAnnouncing(String action, int id, ConfluenceUser applicationUser, String questionnaire) {
        String cacheKey = applicationUser.getKey().getStringValue() + ":::next";
        this.cache.remove((Object)cacheKey);
        return this.announcingHistoryDao.updateAnnouncingAnswerByIdAndUser(id, action, applicationUser.getKey().toString(), questionnaire);
    }

    private AnnouncingHistoryModel entityToModel(AnnouncingHistoryEntity entity) {
        return new AnnouncingHistoryModel(entity.getAnnouncingId(), entity.getName(), this.formatUser(entity.getUser()), entity.getAnswer(), entity.getTimeStamp(), entity.getIp(), entity.getQuestionnaire());
    }

    private String formatUser(String userKey) {
        ConfluenceUser applicationUser = this.userManager.getUserByKey(new UserKey(userKey));
        if (applicationUser == null) {
            return userKey;
        }
        return "<a target='_blank' href='" + this.baseUrl + "/users/viewuserprofile.action?username=" + applicationUser.getName() + "'>" + applicationUser.getFullName() + "</a>";
    }
}

