/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import de.actonic.confluence.gdpr.ao.AccessStatisticsEntity;
import de.actonic.confluence.gdpr.component.manager.AccessStatisticsDao;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.confluence.gdpr.model.AccessStatisticsModel;
import de.actonic.confluence.gdpr.model.ListPaginationModel;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(AccessStatisticsService.class);
    private final AccessStatisticsDao accessStatisticsDao;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userManager;
    private final GDPRSettingsManager GDPRSettingsManager;
    private final UserNameConvertManager userNameConvertManager;
    private final String baseUrl;
    private final IGDPRUserManager gdprUserManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public AccessStatisticsService(AccessStatisticsDao accessStatisticsDao, GDPRSettingsManager GDPRSettingsManager2, UserNameConvertManager userNameConvertManager, PageManager pageManager, UserAccessor userManager, SpaceManager spaceManager, ApplicationProperties applicationProperties, IGDPRUserManager gdprUserManager, I18nResolver i18n) {
        this.accessStatisticsDao = accessStatisticsDao;
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userNameConvertManager = userNameConvertManager;
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.spaceManager = spaceManager;
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.gdprUserManager = gdprUserManager;
        this.i18n = i18n;
    }

    public void addAccessStatisticsEntity(String userKey, String ipAddress, Long pageId, String type) {
        AbstractPage page;
        if (this.GDPRSettingsManager.getTrackPageAccessStatistics().booleanValue() && (page = (AbstractPage)this.pageManager.getById(pageId.longValue())) != null) {
            if ("0:0:0:0:0:0:0:1".equals(ipAddress)) {
                ipAddress = "localhost";
            }
            if ("127.0.0.1".equals(ipAddress)) {
                ipAddress = "localhost";
            }
            this.accessStatisticsDao.addAccessStatisticsEntity(userKey, ipAddress, page.getSpaceKey(), pageId, type);
        }
    }

    public ListPaginationModel filter(String userKey, String spaceKey, String pageId, Long fromDate, Long toDate, String orderBy, Integer page, Integer rowsPerPage) {
        int start;
        this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
        if (page == null) {
            page = 1;
        }
        if ((start = (page - 1) * rowsPerPage) < 0) {
            start = 0;
        }
        int resultSize = -1;
        List<AccessStatisticsModel> accessStatisticsModels = Lists.newArrayList(new AccessStatisticsModel[0]);
        if (StringUtils.isNotBlank((CharSequence)userKey)) {
            accessStatisticsModels = this.filterByUser("html", userKey, fromDate, toDate, orderBy, start, rowsPerPage);
            resultSize = this.accessStatisticsDao.getEntitiesSize(this.accessStatisticsDao.filterQuery("USER_NAME", userKey, fromDate, toDate, null, null, null));
        }
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            accessStatisticsModels = this.filterBySpace("html", spaceKey, fromDate, toDate, orderBy, start, rowsPerPage);
            resultSize = this.accessStatisticsDao.getEntitiesSize(this.accessStatisticsDao.filterQuery("SPACE_KEY", spaceKey, fromDate, toDate, null, null, null));
        }
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            accessStatisticsModels = this.filterByPage("html", pageId, fromDate, toDate, orderBy, start, rowsPerPage);
            resultSize = this.accessStatisticsDao.getEntitiesSize(this.accessStatisticsDao.filterQuery("PAGE_ID", pageId, fromDate, toDate, null, null, null));
        }
        int totalPages = (int)Math.ceil((double)resultSize / (double)rowsPerPage.intValue());
        return new ListPaginationModel(page, totalPages, accessStatisticsModels);
    }

    private List<AccessStatisticsModel> filterByUser(String exportType, String userKey, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        List<AccessStatisticsEntity> accessStatisticsEntities = this.accessStatisticsDao.filterByUser(userKey, fromDate, toDate, sortBy, offset, limit);
        this.filterByDates(accessStatisticsEntities, fromDate, toDate);
        return this.convertAndCollect(accessStatisticsEntities, exportType);
    }

    private List<AccessStatisticsModel> filterBySpace(String exportType, String spaceKey, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        List<AccessStatisticsEntity> accessStatisticsEntities = this.accessStatisticsDao.filterBySpace(spaceKey, fromDate, toDate, sortBy, offset, limit);
        this.filterByDates(accessStatisticsEntities, fromDate, toDate);
        return this.convertAndCollect(accessStatisticsEntities, exportType);
    }

    private List<AccessStatisticsModel> filterByPage(String exportType, String pageId, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        Long pageIdAsLong = Long.valueOf(pageId);
        if (pageIdAsLong != null && pageIdAsLong != 0L) {
            List<AccessStatisticsEntity> accessStatisticsEntities = this.accessStatisticsDao.filterByPage(pageIdAsLong, fromDate, toDate, sortBy, offset, limit);
            this.filterByDates(accessStatisticsEntities, fromDate, toDate);
            return this.convertAndCollect(accessStatisticsEntities, exportType);
        }
        return Lists.newArrayList(new AccessStatisticsModel[0]);
    }

    private void filterByDates(List<AccessStatisticsEntity> accessStatisticsEntities, Long fromDate, Long toDate) {
        accessStatisticsEntities.removeIf(entity -> {
            if (fromDate != null && fromDate != 0L && entity.getTimeStamp().before(new Date(fromDate))) {
                return true;
            }
            return toDate != null && toDate != 0L && entity.getTimeStamp().after(new Date(toDate));
        });
    }

    private List<AccessStatisticsModel> convertAndCollect(List<AccessStatisticsEntity> accessStatisticsEntities, String exportType) {
        return accessStatisticsEntities.stream().map(entity -> {
            if ("html".equals(exportType)) {
                String userName = this.userNameConvertManager.convertUserKeyToUserName(entity.getUserName());
                return new AccessStatisticsModel(entity.getTimeStamp(), this.formatUser(userName), this.formatSpace(entity.getSpaceKey()), this.formatPage(entity.getPageId()), entity.getIpAddress(), entity.getType());
            }
            return new AccessStatisticsModel((AccessStatisticsEntity)entity);
        }).collect(Collectors.toList());
    }

    private String formatUser(String userName) {
        ConfluenceUser applicationUser = this.userManager.getUserByName(userName);
        if (applicationUser == null) {
            return "[anonymous]".equals(userName) ? "anonymous" : "Unknown user '" + userName + "'";
        }
        return "<a target='_blank' href='" + this.baseUrl + "/users/viewuserprofile.action?username=" + userName + "'>" + applicationUser.getFullName() + "</a>";
    }

    private String formatSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return "Unknown space '" + spaceKey + "'";
        }
        return "<a target='_blank' href='" + this.baseUrl + "/display/" + spaceKey + "'>" + space.getName() + "</a>";
    }

    private String formatPage(Long pageId) {
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null) {
            return "Unknown page '" + pageId + "'";
        }
        return "<a target='_blank' href='" + this.baseUrl + "/pages/viewpage.action?pageId=" + pageId + "'>" + page.getTitle() + "</a>";
    }

    private void sortItems(List<AccessStatisticsModel> accessStatisticsModels, String sortBy) {
        if ("dateAsc".equals(sortBy)) {
            Collections.sort(accessStatisticsModels, Comparator.comparing(AccessStatisticsModel::getTimeStamp));
        }
        if ("dateDesc".equals(sortBy)) {
            Collections.sort(accessStatisticsModels, (event1, event2) -> event2.getTimeStamp().compareTo(event1.getTimeStamp()));
        }
        if ("user".equals(sortBy)) {
            Collections.sort(accessStatisticsModels, Comparator.comparing(AccessStatisticsModel::getUserName));
        }
    }

    public void deleteOldStatistics() {
        Integer LIMIT = 1000;
        Integer purgeAccessStatisticsAfter = this.GDPRSettingsManager.getPurgeAccessStatisticsAfter();
        Integer total = this.accessStatisticsDao.countAllEntities();
        LocalDate today = LocalDate.now();
        for (int i = 0; i < total; i += LIMIT.intValue()) {
            List<AccessStatisticsEntity> entities = this.accessStatisticsDao.getAllEntities(i, LIMIT);
            for (AccessStatisticsEntity entity : entities) {
                long daysBetween = ChronoUnit.DAYS.between(entity.getTimeStamp().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), today);
                if (daysBetween <= (long)purgeAccessStatisticsAfter.intValue()) continue;
                this.accessStatisticsDao.deleteEntities(entity);
            }
        }
    }
}

