/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.ao.RequestDataEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.model.RequestDataStatus;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestMyDataDao
extends AbstractEntityDao {
    @Autowired
    public RequestMyDataDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public void create(String userKey) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = (RequestDataEntity)this.ao.create(RequestDataEntity.class, new DBParam[0]);
            entity.setUserKey(userKey);
            entity.setCreateDate(System.currentTimeMillis());
            entity.setEnds(false);
            entity.setCancel(false);
            entity.setError(false);
            entity.setStatus(RequestDataStatus.CREATE.getText());
            entity.save();
            return true;
        });
    }

    public void update(int id, String status, String extraFields) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setStatus(status);
            entity.setExtraFields(extraFields);
            entity.save();
            return true;
        });
    }

    public void delete(int id) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            this.ao.delete(new RawEntity[]{entity});
            return true;
        });
    }

    public void start(int id) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setStatus(RequestDataStatus.WORK.getText());
            entity.setStartDate(System.currentTimeMillis());
            entity.save();
            return true;
        });
    }

    public void status(int id, String status) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setStatus(status);
            entity.save();
            return true;
        });
    }

    public void cancel(int id) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setCancel(true);
            entity.setEnds(true);
            entity.setError(false);
            entity.setStatus(RequestDataStatus.CANCEL.getText());
            entity.setEndDate(System.currentTimeMillis());
            entity.save();
            return true;
        });
    }

    public void error(int id, String errorMessage) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setError(true);
            entity.setEnds(true);
            entity.setCancel(false);
            entity.setStatus(RequestDataStatus.ERROR.getText());
            entity.setEndDate(System.currentTimeMillis());
            entity.setExtraFields(errorMessage);
            entity.save();
            return true;
        });
    }

    public void finish(int id) {
        this.ao.executeInTransaction(() -> {
            RequestDataEntity entity = this.getFirstByField(RequestDataEntity.class, "ID", id);
            entity.setError(false);
            entity.setEnds(true);
            entity.setCancel(false);
            entity.setStatus(RequestDataStatus.DONE.getText());
            entity.setEndDate(System.currentTimeMillis());
            entity.save();
            return true;
        });
    }

    public RequestDataEntity get(int id) {
        return this.getLastByField(RequestDataEntity.class, "ID", id);
    }

    public RequestDataEntity get(String userKey) {
        return this.getLastByField(RequestDataEntity.class, "USER_KEY", userKey);
    }

    public RequestDataEntity getLastFinished(String userKey) {
        return this.getLastByQuery(RequestDataEntity.class, Query.select().where("USER_KEY = ? AND STATUS = ?", new Object[]{userKey, RequestDataStatus.DONE.getText()}));
    }

    public RequestDataEntity getCurrent() {
        return this.getFirstByField(RequestDataEntity.class, "STATUS", RequestDataStatus.WORK.getText());
    }

    public RequestDataEntity getNext() {
        return this.getFirstByField(RequestDataEntity.class, "STATUS", RequestDataStatus.CREATE.getText());
    }

    public List<RequestDataEntity> getQueue() {
        List<Object> result = Arrays.asList((Object[])this.ao.executeInTransaction(() -> (RequestDataEntity[])this.ao.find(RequestDataEntity.class, Query.select().where("STATUS = ?", new Object[]{RequestDataStatus.CREATE.getText()}).order("CREATE_DATE desc"))));
        return result;
    }

    public List<RequestDataEntity> getHistory() {
        List<Object> result = Arrays.asList((Object[])this.ao.executeInTransaction(() -> (RequestDataEntity[])this.ao.find(RequestDataEntity.class, Query.select().where("ENDS = true", new Object[0]).order("CREATE_DATE desc"))));
        return result;
    }

    public boolean isRequestAlreadyExists(String userKey) {
        RequestDataEntity entity = this.getFirstByQuery(RequestDataEntity.class, Query.select().where("USER_KEY = ? AND (STATUS = 'created' OR STATUS = 'work')", new Object[]{userKey}));
        return entity != null;
    }
}

