/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.audit.api.AuditService;
import com.atlassian.confluence.api.model.audit.ChangedValue;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.util.Lists;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PluginAuditManager {
    private static final String GDPR_CATEGORY_KEY = "de.actonic.confluence.dgpr-tools";
    @ComponentImport
    private final AuditService auditService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager GDPRSettingsManager;

    @Autowired
    public PluginAuditManager(GDPRSettingsManager GDPRSettingsManager2, UserAccessor userAccessor, @Qualifier(value="auditService") AuditService auditSessionService) {
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userAccessor = userAccessor;
        this.auditService = auditSessionService;
    }

    public Integer saveAudit(String rowsPerPage, String purgeAccessStatisticsAfter, String runTasksFromUser, String runGdprGroup, boolean trackPageAccessStatistics) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        User currentModelUser = new User(null, applicationUser.getName(), applicationUser.getFullName(), applicationUser.getKey());
        ArrayList<ChangedValue> changedValues = Lists.newArrayList(new ChangedValue[0]);
        boolean hasModifiedValue = false;
        if (!this.GDPRSettingsManager.getRowsPerPage().toString().equals(rowsPerPage)) {
            ChangedValue changedRowsPerPage = ChangedValue.builder().name(String.format("'Rows per page' modified from %s to %s", this.GDPRSettingsManager.getRowsPerPage(), rowsPerPage)).oldValue(this.GDPRSettingsManager.getRowsPerPage().toString()).newValue(rowsPerPage).build();
            changedValues.add(changedRowsPerPage);
            hasModifiedValue = true;
        }
        if (this.GDPRSettingsManager.getTrackPageAccessStatistics() != trackPageAccessStatistics) {
            String before = this.GDPRSettingsManager.getTrackPageAccessStatistics() != false ? "checked" : "unchecked";
            String after = trackPageAccessStatistics ? "checked" : "unchecked";
            ChangedValue changedTrackPageAccessStatistics = ChangedValue.builder().name(String.format("User switched from %s to %s", before, after)).oldValue(before).newValue(after).build();
            changedValues.add(changedTrackPageAccessStatistics);
            hasModifiedValue = true;
        }
        if (!this.GDPRSettingsManager.getPurgeAccessStatisticsAfter().toString().equals(purgeAccessStatisticsAfter)) {
            ChangedValue changedPurgeAccessStatisticsAfter = ChangedValue.builder().name(String.format("'Purge Issue access log after' modified from %s to %s", this.GDPRSettingsManager.getRowsPerPage(), rowsPerPage)).oldValue(this.GDPRSettingsManager.getPurgeAccessStatisticsAfter().toString()).newValue(purgeAccessStatisticsAfter).build();
            changedValues.add(changedPurgeAccessStatisticsAfter);
            hasModifiedValue = true;
        }
        if (StringUtils.isNotBlank((CharSequence)runTasksFromUser)) {
            String oldRunTasksFromUser = this.GDPRSettingsManager.getRunTasksFromUser();
            ChangedValue changedRunTasksFromUser = ChangedValue.builder().name(String.format("'Run all background tasks from user' modified from %s to %s", oldRunTasksFromUser, runTasksFromUser)).oldValue(oldRunTasksFromUser).newValue(runTasksFromUser).build();
            changedValues.add(changedRunTasksFromUser);
            hasModifiedValue = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.GDPRSettingsManager.getAllowedGroup()) && !runGdprGroup.equals(this.GDPRSettingsManager.getAllowedGroup())) {
            ChangedValue changedRunGdprGroup = ChangedValue.builder().name(String.format("'GDPR and Security administrators' modified from %s to %s", this.GDPRSettingsManager.getAllowedGroup(), runGdprGroup)).oldValue(this.GDPRSettingsManager.getAllowedGroup()).newValue(runGdprGroup).build();
            changedValues.add(changedRunGdprGroup);
            hasModifiedValue = true;
        }
        return null;
    }
}

