/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.model.JobStatusModel;
import de.actonic.confluence.gdpr.model.JobStatusTypeModel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobWrapperManager {
    private final Logger logger = LoggerFactory.getLogger(JobWrapperManager.class);
    private final PluginSettings pluginSettings;
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @ComponentImport
    private CacheManager cacheManager;

    @Autowired
    public JobWrapperManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate, CacheManager cacheManager) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.jobs");
        this.transactionTemplate = transactionTemplate;
        this.cacheManager = cacheManager;
    }

    public boolean isJobCancelled(String jobName) {
        Cache cache = this.cacheManager.getCache(jobName + "-cancellation");
        if (cache.containsKey((Object)(jobName + "-cancellation"))) {
            return Boolean.valueOf((String)cache.get((Object)(jobName + "-cancellation")));
        }
        return false;
    }

    public void setJobCancelled(String jobName) {
        Cache cache = this.cacheManager.getCache(jobName + "-cancellation");
        cache.put((Object)(jobName + "-cancellation"), (Object)String.valueOf(true));
    }

    public void removeJobCancelled(String jobName) {
        Cache cache = this.cacheManager.getCache(jobName + "-cancellation");
        cache.remove((Object)(jobName + "-cancellation"));
    }

    public void setStartStatus(String jobName, Map additionalParams) {
        JobStatusModel statusModel = new JobStatusModel(additionalParams);
        statusModel.setCurrentStatus(JobStatusTypeModel.IN_PROGRESS.getCode());
        this.pluginSettings.put(jobName + "-status", (Object)new Gson().toJson((Object)statusModel));
    }

    public void setStatus(String jobName, String message, Map additionalParams) {
        Object statusAsObj = this.pluginSettings.get(jobName + "-status");
        if (statusAsObj != null) {
            JobStatusModel statusModel = (JobStatusModel)new Gson().fromJson((String)statusAsObj, JobStatusModel.class);
            statusModel.setMessage(message);
            if (additionalParams != null) {
                HashMap currentParams = statusModel.getParams();
                if (currentParams == null) {
                    currentParams = new HashMap();
                }
                currentParams.putAll(additionalParams);
                statusModel.setParams(currentParams);
            }
            this.pluginSettings.put(jobName + "-status", (Object)new Gson().toJson((Object)statusModel));
        } else {
            this.logger.warn("Trying to change job search status, but job is null.");
        }
    }

    public void setCancellationStatus(String jobName, String message) {
        Object statusAsObj = this.pluginSettings.get(jobName + "-status");
        if (statusAsObj != null) {
            JobStatusModel statusModel = (JobStatusModel)new Gson().fromJson((String)statusAsObj, JobStatusModel.class);
            if (statusModel.getCurrentStatus() == JobStatusTypeModel.IN_PROGRESS.getCode()) {
                statusModel.setCurrentStatus(JobStatusTypeModel.ABORTED.getCode());
                statusModel.setMessage(message);
                this.pluginSettings.put(jobName + "-status", (Object)new Gson().toJson((Object)statusModel));
            }
        } else {
            this.logger.warn("Trying to set cancellation for search job, but job is null.");
        }
    }

    public void setFinishStatus(String jobName) {
        Object statusAsObj = this.pluginSettings.get(jobName + "-status");
        if (statusAsObj != null) {
            JobStatusModel statusModel = (JobStatusModel)new Gson().fromJson((String)statusAsObj, JobStatusModel.class);
            statusModel.setCurrentStatus(JobStatusTypeModel.FINISHED.getCode());
            statusModel.setMessage("Completed!");
            this.pluginSettings.put(jobName + "-status", (Object)new Gson().toJson((Object)statusModel));
        }
    }

    public JobStatusModel getStatus(String jobName) {
        Object searchStatusObj = this.pluginSettings.get(jobName + "-status");
        if (searchStatusObj != null) {
            JobStatusModel statusModel = (JobStatusModel)new Gson().fromJson((String)searchStatusObj, JobStatusModel.class);
            return statusModel;
        }
        return null;
    }

    public void removeJobStatus(String jobName) {
        this.pluginSettings.remove(jobName + "-status");
    }
}

