/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.ao.DataRuleHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleHistoryDao
extends AbstractEntityDao {
    @Autowired
    public DataRuleHistoryDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public DataRuleHistoryEntity getById(int id) {
        DataRuleHistoryEntity entity = this.getFirstByField(DataRuleHistoryEntity.class, "ID", id);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    public DataRuleHistoryEntity createEntity(int ruleId, String details, String pageIds, int resultCode) {
        return (DataRuleHistoryEntity)this.ao.executeInTransaction(() -> {
            DataRuleHistoryEntity entity = (DataRuleHistoryEntity)this.ao.create(DataRuleHistoryEntity.class, new DBParam[0]);
            entity.setRuleId(ruleId);
            entity.setDetails(details);
            entity.setPageIds(pageIds);
            entity.setTimeStamp(new Date());
            entity.setResultCode(resultCode);
            entity.save();
            return entity;
        });
    }

    public void deleteEntity(int id) {
        DataRuleHistoryEntity entity = this.getFirstByField(DataRuleHistoryEntity.class, "ID", id);
        if (entity != null) {
            this.ao.delete(new RawEntity[]{entity});
        }
    }

    public List<DataRuleHistoryEntity> getAllEntities() {
        DataRuleHistoryEntity[] entities = (DataRuleHistoryEntity[])this.ao.find(DataRuleHistoryEntity.class);
        return Lists.newArrayList(entities);
    }

    public List<DataRuleHistoryEntity> getAllEntitiesByRule(int ruleId) {
        DataRuleHistoryEntity[] entities = (DataRuleHistoryEntity[])this.ao.find(DataRuleHistoryEntity.class, Query.select().where("RULE_ID = ?", new Object[]{ruleId}));
        return Lists.newArrayList(entities);
    }
}

