/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.ao.AccessStatisticsEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.util.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessStatisticsDao
extends AbstractEntityDao {
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public AccessStatisticsDao(@ComponentImport ActiveObjects ao, TransactionTemplate transactionTemplate) {
        super(ao);
        this.transactionTemplate = transactionTemplate;
    }

    public AccessStatisticsEntity addAccessStatisticsEntity(String userKey, String ipAddress, String spaceKey, Long pageId, String type) {
        return (AccessStatisticsEntity)this.transactionTemplate.execute(() -> {
            AccessStatisticsEntity entity = (AccessStatisticsEntity)this.ao.create(AccessStatisticsEntity.class, new DBParam[0]);
            entity.setUserName(userKey);
            entity.setSpaceKey(spaceKey);
            entity.setPageId(pageId);
            entity.setIpAddress(ipAddress);
            entity.setTimeStamp(new Date());
            entity.setType(type);
            entity.save();
            return entity;
        });
    }

    public Integer countAllEntities() {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(AccessStatisticsEntity.class));
    }

    public List<AccessStatisticsEntity> getAllEntities() {
        return (List)this.ao.executeInTransaction(() -> {
            AccessStatisticsEntity[] entities = (AccessStatisticsEntity[])this.ao.find(AccessStatisticsEntity.class);
            return Lists.newArrayList(entities);
        });
    }

    public List<AccessStatisticsEntity> getAllEntities(Integer offset, Integer limit) {
        return (List)this.ao.executeInTransaction(() -> {
            AccessStatisticsEntity[] entities = (AccessStatisticsEntity[])this.ao.find(AccessStatisticsEntity.class, this.withLimit(Query.select(), offset, limit));
            return Lists.newArrayList(entities);
        });
    }

    public void deleteEntity(int id) {
        AccessStatisticsEntity entity = this.getFirstByField(AccessStatisticsEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public void deleteEntities(AccessStatisticsEntity ... accessStatisticsEntities) {
        this.ao.executeInTransaction(() -> {
            this.ao.delete((RawEntity[])accessStatisticsEntities);
            return true;
        });
    }

    public int getEntitiesSize(Query query) {
        return query != null ? this.ao.count(AccessStatisticsEntity.class, query) : this.ao.count(AccessStatisticsEntity.class);
    }

    public Query filterQuery(String filterKey, String filterValue, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        Query query;
        long customPageId = 0L;
        if (filterKey.equalsIgnoreCase("PAGE_ID")) {
            customPageId = Long.parseLong(filterValue);
            query = Query.select().where(filterKey + " = ?", new Object[]{customPageId});
        } else {
            query = Query.select().where(filterKey + " = ?", new Object[]{filterValue});
        }
        query = this.withDates(query, fromDate, toDate);
        query = this.withSorting(query, sortBy);
        query = this.withLimit(query, offset, limit);
        return query;
    }

    public List<AccessStatisticsEntity> filterByUser(String userKey, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        Query query = this.filterQuery("USER_NAME", userKey, fromDate, toDate, sortBy, offset, limit);
        AccessStatisticsEntity[] entities = (AccessStatisticsEntity[])this.ao.find(AccessStatisticsEntity.class, query);
        return Lists.newArrayList(entities);
    }

    public List<AccessStatisticsEntity> filterBySpace(String spaceKey, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        Query query = this.filterQuery("SPACE_KEY", spaceKey, fromDate, toDate, sortBy, offset, limit);
        AccessStatisticsEntity[] entities = (AccessStatisticsEntity[])this.ao.find(AccessStatisticsEntity.class, query);
        return Lists.newArrayList(entities);
    }

    public List<AccessStatisticsEntity> filterByPage(Long pageId, Long fromDate, Long toDate, String sortBy, Integer offset, Integer limit) {
        Query query = this.filterQuery("PAGE_ID", pageId.toString(), fromDate, toDate, sortBy, offset, limit);
        AccessStatisticsEntity[] entities = (AccessStatisticsEntity[])this.ao.find(AccessStatisticsEntity.class, query);
        return Lists.newArrayList(entities);
    }

    public Query withDates(Query query, Long fromDate, Long toDate) {
        String whereCause = query.getWhereClause();
        ArrayList<Object> whereParams = Lists.newArrayList(query.getWhereParams());
        if (fromDate != null && fromDate != 0L) {
            whereCause = whereCause + " AND TIME_STAMP >= ?";
            whereParams.add(new Date(fromDate));
        }
        if (toDate != null && toDate != 0L) {
            whereCause = whereCause + " AND TIME_STAMP <= ?";
            whereParams.add(new Date(toDate));
        }
        return query.where(whereCause, whereParams.toArray());
    }

    public Query withSorting(Query query, String sortBy) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sortBy})) {
            return query;
        }
        if ("dateAsc".equals(sortBy)) {
            query = query.order("TIME_STAMP ASC");
        }
        if ("dateDesc".equals(sortBy)) {
            query = query.order("TIME_STAMP DESC");
        }
        if ("user".equals(sortBy)) {
            query = query.order("USER_NAME ASC");
        }
        return query;
    }

    public Query withLimit(Query query, Integer offset, Integer limit) {
        if (offset != null && offset != 0) {
            query.offset(offset.intValue());
        }
        if (limit != null && limit != 0) {
            query.limit(limit.intValue());
        }
        return query;
    }
}

