/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.scheduling;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import de.actonic.confluence.gdpr.common.datacleaner.scheduling.DataCleanerTaskJob;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskExecutionService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DataCleanerTaskJobStarter
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskJobStarter.class);
    private static final String JOB_NAME = DataCleanerTaskJobStarter.class.getName() + ":job";
    @ComponentImport
    private final PluginScheduler pluginScheduler;
    private final DataCleanerTaskExecutionService dataCleanerTaskService;
    private long interval = 10000L;

    @Autowired
    public DataCleanerTaskJobStarter(PluginScheduler pluginScheduler, DataCleanerTaskExecutionService dataCleanerTaskService) {
        this.pluginScheduler = pluginScheduler;
        this.dataCleanerTaskService = dataCleanerTaskService;
    }

    public void onStart() {
        this.schedule();
    }

    private void schedule() {
        this.pluginScheduler.scheduleJob(JOB_NAME, DataCleanerTaskJob.class, (Map)new HashMap<String, Object>(){
            {
                this.put("dataCleanerTaskService", DataCleanerTaskJobStarter.this.dataCleanerTaskService);
            }
        }, new Date(), this.interval);
    }

    @PreDestroy
    public void onStop() {
        this.pluginScheduler.unscheduleJob(JOB_NAME);
    }
}

