/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerCreateTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerQuickUserTemplateModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskExecutionService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/data-cleaner-template/task")
@Produces(value={"application/json"})
@Component
public class DataCleanerTaskRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskRest.class);
    private DataCleanerService dataCleanerService;
    private DataCleanerTaskService dataCleanerTaskService;
    private DataCleanerTaskExecutionService dataCleanerTaskExecutionService;
    private DataCleanerTemplateService dataCleanerTemplateService;

    @Autowired
    public DataCleanerTaskRest(DataCleanerService dataCleanerService, DataCleanerTaskService dataCleanerTaskService, DataCleanerTaskExecutionService dataCleanerTaskExecutionService, DataCleanerTemplateService dataCleanerTemplateService) {
        this.dataCleanerService = dataCleanerService;
        this.dataCleanerTaskService = dataCleanerTaskService;
        this.dataCleanerTaskExecutionService = dataCleanerTaskExecutionService;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response addTask(DataCleanerCreateTaskModel model) {
        try {
            DataCleanerTemplateModel templateModel = this.dataCleanerTemplateService.getTemplate(model.getTemplateId());
            model.setTemplateType(templateModel.getTemplateType());
            DataCleanerTaskModel dataCleanerTaskModel = this.dataCleanerTaskService.createTask(model, templateModel);
            if (this.dataCleanerTaskService.hasTaskForStart()) {
                this.dataCleanerTaskExecutionService.executeIfExists();
            }
            return Response.ok((Object)new Gson().toJson((Object)dataCleanerTaskModel)).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/status")
    public Response getStatus() {
        return Response.ok((Object)this.dataCleanerTaskExecutionService.getCurrentStatus()).build();
    }

    @GET
    @Path(value="/{id}")
    public Response getTask(@PathParam(value="id") int id) {
        return Response.ok((Object)new Gson().toJson(this.dataCleanerTaskService.getTaskById(id))).build();
    }

    @GET
    @Path(value="/tasks")
    @Consumes(value={"application/json"})
    public Response getTaskList() {
        return Response.ok(this.dataCleanerTaskService.getCurrentTasks()).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response cancelTask(@PathParam(value="id") int templateId) {
        try {
            this.dataCleanerTaskService.cancelTask(templateId);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/flush")
    @Consumes(value={"application/json"})
    public Response flushTaskList() {
        Integer flushedSize = this.dataCleanerTaskService.flushInQueueTasks();
        return Response.ok().entity((Object)("Canceled by request '" + flushedSize + "' tasks")).build();
    }

    @POST
    @Path(value="/quick-user-anonymize")
    public Response quickUserAnonymize(DataCleanerQuickUserTemplateModel dataCleanerTemplateModel) {
        try {
            DataCleanerTaskModel dataCleanerTaskModel = this.dataCleanerService.quickUserAnonymize(dataCleanerTemplateModel);
            return Response.ok((Object)new Gson().toJson((Object)dataCleanerTaskModel)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

