/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerScheduleModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerSchedulerManager;
import de.actonic.confluence.gdpr.util.Maps;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/data-cleaner-template/scheduler")
@Produces(value={"application/json"})
@Component
public class DataCleanerSchedulerRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerSchedulerRest.class);
    private final DataCleanerSchedulerManager dataCleanerSchedulerManager;
    private final Gson gson = new Gson();

    @Autowired
    public DataCleanerSchedulerRest(DataCleanerSchedulerManager dataCleanerSchedulerManager) {
        this.dataCleanerSchedulerManager = dataCleanerSchedulerManager;
    }

    @POST
    @Path(value="/")
    public Response createCron(DataCleanerScheduleModel model) {
        DataCleanerScheduleModel cron = this.dataCleanerSchedulerManager.createCron(model);
        return Response.ok((Object)this.gson.toJson((Object)cron)).build();
    }

    @PUT
    @Path(value="/{cronId}")
    public Response updateCron(@PathParam(value="cronId") Integer cronId, DataCleanerScheduleModel model) {
        try {
            DataCleanerScheduleModel cron = this.dataCleanerSchedulerManager.updateCron(cronId, model);
            return Response.ok((Object)this.gson.toJson((Object)cron)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cron with id=" + cronId + " not found, please check parameters")).build();
        }
    }

    @GET
    @Path(value="/cronsForTemplate/{templateId}")
    public Response getCronsForTemplate(@PathParam(value="templateId") Integer templateId) {
        List<DataCleanerScheduleModel> crons = this.dataCleanerSchedulerManager.getCronsForTemplate(templateId);
        return Response.ok((Object)this.gson.toJson(crons)).build();
    }

    @GET
    @Path(value="/{cronId}")
    public Response getCron(@PathParam(value="cronId") Integer cronId) {
        DataCleanerScheduleModel cron = this.dataCleanerSchedulerManager.getCron(cronId);
        if (cron != null) {
            return Response.ok((Object)this.gson.toJson((Object)cron)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cron with id=" + cronId + " not found, please check parameters")).build();
    }

    @GET
    @Path(value="/cron")
    public Response isCronValid(@QueryParam(value="cron") String cron) {
        boolean isValid = this.dataCleanerSchedulerManager.isCronValid(cron);
        return Response.ok((Object)this.gson.toJson(Maps.getMapData("isValid", isValid, "humanReadable", (Object)this.dataCleanerSchedulerManager.getHumanReadableFormat(cron)))).build();
    }
}

